
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Root element for profile content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeleteProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DeleteTPAIdentityType" name="TPA_Identity"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="PurgeDays"/>
 *   &lt;xs:attribute type="ns:StatusType" use="optional" default="DL" name="StatusCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DeleteProfileType implements Serializable
{
    private DeleteTPAIdentityType TPAIdentity;
    private String purgeDays;
    private StatusType statusCode;

    /** 
     * Get the 'TPA_Identity' element value. *** SABRE ADDED *** Profile Delete data holder
     * 
     * @return value
     */
    public DeleteTPAIdentityType getTPAIdentity() {
        return TPAIdentity;
    }

    /** 
     * Set the 'TPA_Identity' element value. *** SABRE ADDED *** Profile Delete data holder
     * 
     * @param TPAIdentity
     */
    public void setTPAIdentity(DeleteTPAIdentityType TPAIdentity) {
        this.TPAIdentity = TPAIdentity;
    }

    /** 
     * Get the 'PurgeDays' attribute value. Number of days after which the profile needs to be purged, if the value is 0 then it is an immediate Delete if not it is a flag for future delete
     * 
     * @return value
     */
    public String getPurgeDays() {
        return purgeDays;
    }

    /** 
     * Set the 'PurgeDays' attribute value. Number of days after which the profile needs to be purged, if the value is 0 then it is an immediate Delete if not it is a flag for future delete
     * 
     * @param purgeDays
     */
    public void setPurgeDays(String purgeDays) {
        this.purgeDays = purgeDays;
    }

    /** 
     * Get the 'StatusCode' attribute value.
     * 
     * @return value
     */
    public StatusType getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' attribute value.
     * 
     * @param statusCode
     */
    public void setStatusCode(StatusType statusCode) {
        this.statusCode = statusCode;
    }
}
