
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Limited to schema subtrees that are at the level of Profile/Customer/xxxxx like PaymentForm or TPA_ProfileExtensions/xxxx like BusinessTraveler NOTE: PersonName cannot be deleted.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeleteSubtreeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PartialUpdateProfileType" name="MatchSubtree"/>
 *     &lt;xs:element type="ns:PartialUpdateIgnoreAttributesType" name="IgnoreMatchAttribute" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:PartialChildDataType" use="required" name="child"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DeleteSubtreeType implements Serializable
{
    private PartialUpdateProfileType matchSubtree;
    private PartialUpdateIgnoreAttributesType ignoreMatchAttribute;
    private PartialChildDataType child;

    /** 
     * Get the 'MatchSubtree' element value. Requirement for min 1 instance for general case of subtrees with multiple instances. For subtrees with a single instance like Customer matching data not required
     * 
     * @return value
     */
    public PartialUpdateProfileType getMatchSubtree() {
        return matchSubtree;
    }

    /** 
     * Set the 'MatchSubtree' element value. Requirement for min 1 instance for general case of subtrees with multiple instances. For subtrees with a single instance like Customer matching data not required
     * 
     * @param matchSubtree
     */
    public void setMatchSubtree(PartialUpdateProfileType matchSubtree) {
        this.matchSubtree = matchSubtree;
    }

    /** 
     * Get the 'IgnoreMatchAttribute' element value. Attributes that will be ignored during element matching
     * 
     * @return value
     */
    public PartialUpdateIgnoreAttributesType getIgnoreMatchAttribute() {
        return ignoreMatchAttribute;
    }

    /** 
     * Set the 'IgnoreMatchAttribute' element value. Attributes that will be ignored during element matching
     * 
     * @param ignoreMatchAttribute
     */
    public void setIgnoreMatchAttribute(
            PartialUpdateIgnoreAttributesType ignoreMatchAttribute) {
        this.ignoreMatchAttribute = ignoreMatchAttribute;
    }

    /** 
     * Get the 'child' attribute value.
     * 
     * @return value
     */
    public PartialChildDataType getChild() {
        return child;
    }

    /** 
     * Set the 'child' attribute value.
     * 
     * @param child
     */
    public void setChild(PartialChildDataType child) {
        this.child = child;
    }
}
