
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Added by Sabre
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeleteTPAIdentityType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DeleteLoginType" name="Login" minOccurs="0"/>
 *     &lt;xs:element type="ns:ProfileSubTypeType" name="ProfileSubType" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:AuxiliaryIDType" name="AuxiliaryID" minOccurs="0" maxOccurs="5"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="UniqueID"/>
 *   &lt;xs:attribute type="ns:ProfileTypeInfo" use="required" name="ProfileTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProfileName"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DeleteTPAIdentityType implements Serializable
{
    private DeleteLoginType login;
    private List<ProfileSubTypeType> profileSubTypeList = new ArrayList<ProfileSubTypeType>();
    private List<AuxiliaryIDType> auxiliaryIDList = new ArrayList<AuxiliaryIDType>();
    private String clientCode;
    private String clientContextCode;
    private String uniqueID;
    private ProfileTypeInfo profileTypeCode;
    private String profileName;
    private String domainID;

    /** 
     * Get the 'Login' element value.
     * 
     * @return value
     */
    public DeleteLoginType getLogin() {
        return login;
    }

    /** 
     * Set the 'Login' element value.
     * 
     * @param login
     */
    public void setLogin(DeleteLoginType login) {
        this.login = login;
    }

    /** 
     * Get the list of 'ProfileSubType' element items.
     * 
     * @return list
     */
    public List<ProfileSubTypeType> getProfileSubTypeList() {
        return profileSubTypeList;
    }

    /** 
     * Set the list of 'ProfileSubType' element items.
     * 
     * @param list
     */
    public void setProfileSubTypeList(List<ProfileSubTypeType> list) {
        profileSubTypeList = list;
    }

    /** 
     * Get the list of 'AuxiliaryID' element items.
     * 
     * @return list
     */
    public List<AuxiliaryIDType> getAuxiliaryIDList() {
        return auxiliaryIDList;
    }

    /** 
     * Set the list of 'AuxiliaryID' element items.
     * 
     * @param list
     */
    public void setAuxiliaryIDList(List<AuxiliaryIDType> list) {
        auxiliaryIDList = list;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'UniqueID' attribute value.
     * 
     * @return value
     */
    public String getUniqueID() {
        return uniqueID;
    }

    /** 
     * Set the 'UniqueID' attribute value.
     * 
     * @param uniqueID
     */
    public void setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    /** 
     * Get the 'ProfileTypeCode' attribute value.
     * 
     * @return value
     */
    public ProfileTypeInfo getProfileTypeCode() {
        return profileTypeCode;
    }

    /** 
     * Set the 'ProfileTypeCode' attribute value.
     * 
     * @param profileTypeCode
     */
    public void setProfileTypeCode(ProfileTypeInfo profileTypeCode) {
        this.profileTypeCode = profileTypeCode;
    }

    /** 
     * Get the 'ProfileName' attribute value.
     * 
     * @return value
     */
    public String getProfileName() {
        return profileName;
    }

    /** 
     * Set the 'ProfileName' attribute value.
     * 
     * @param profileName
     */
    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    /** 
     * Get the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
    	
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
    	
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }
}
