
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * *** SABRE ADDED *** Defines the Dictionary with Control Codes
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DictionaryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DictionaryIdentityType" name="DictionaryIdentity"/>
 *     &lt;xs:element type="ns:DictionaryEntryType" name="DictionaryEntry" maxOccurs="250"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DictionaryType implements Serializable
{
    private DictionaryIdentityType dictionaryIdentity;
    private List<DictionaryEntryType> dictionaryEntryList = new ArrayList<DictionaryEntryType>();

    /** 
     * Get the 'DictionaryIdentity' element value.
     * 
     * @return value
     */
    public DictionaryIdentityType getDictionaryIdentity() {
        return dictionaryIdentity;
    }

    /** 
     * Set the 'DictionaryIdentity' element value.
     * 
     * @param dictionaryIdentity
     */
    public void setDictionaryIdentity(DictionaryIdentityType dictionaryIdentity) {
        this.dictionaryIdentity = dictionaryIdentity;
    }

    /** 
     * Get the list of 'DictionaryEntry' element items.
     * 
     * @return list
     */
    public List<DictionaryEntryType> getDictionaryEntryList() {
        return dictionaryEntryList;
    }

    /** 
     * Set the list of 'DictionaryEntry' element items.
     * 
     * @param list
     */
    public void setDictionaryEntryList(List<DictionaryEntryType> list) {
        dictionaryEntryList = list;
    }
}
