
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Provides information on a specific documents
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DocumentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DocHolderName" minOccurs="0"/>
 *     &lt;xs:element type="ns:DocHolderNameType" name="DocHolder" minOccurs="0"/>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DocIssueLocation"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DocID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DocTypeCode"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="BirthDate"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="EffectiveDate"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="ExpireDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DocIssueCountryCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BirthPlace"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BirthCountryCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DocHolderNationalityCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="ns:VIT_StarLineType" use="optional" name="VIT_LineType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_SecondaryQualifier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_OrderNmbr"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GenderCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="IsUsedForSecureFlightRules"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DocumentType implements Serializable
{
    private String docHolderName;
    private DocHolderNameType docHolder;
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String docIssueLocation;
    private String docID;
    private String docTypeCode;
    private Date birthDate;
    private Date effectiveDate;
    private Date expireDate;
    private String docIssueCountryCode;
    private String birthPlace;
    private String birthCountryCode;
    private String docHolderNationalityCode;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private VITStarLineType VITLineType;
    private String VITSecondaryQualifier;
    private String VITOrderNmbr;
    private String genderCode;
    private String informationText;
    private YesNoType isUsedForSecureFlightRules;

    /** 
     * Get the 'DocHolderName' element value. Depricated since schema 4.2.3
     * 
     * @return value
     */
    public String getDocHolderName() {
        return docHolderName;
    }

    /** 
     * Set the 'DocHolderName' element value. Depricated since schema 4.2.3
     * 
     * @param docHolderName
     */
    public void setDocHolderName(String docHolderName) {
        this.docHolderName = docHolderName;
    }

    /** 
     * Get the 'DocHolder' element value. This holds the document firstName, lastName, middlename..
     * 
     * @return value
     */
    public DocHolderNameType getDocHolder() {
        return docHolder;
    }

    /** 
     * Set the 'DocHolder' element value. This holds the document firstName, lastName, middlename..
     * 
     * @param docHolder
     */
    public void setDocHolder(DocHolderNameType docHolder) {
        this.docHolder = docHolder;
    }

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'DocIssueLocation' attribute value. Indicates the location where the document was issued.
     * 
     * @return value
     */
    public String getDocIssueLocation() {
        return docIssueLocation;
    }

    /** 
     * Set the 'DocIssueLocation' attribute value. Indicates the location where the document was issued.
     * 
     * @param docIssueLocation
     */
    public void setDocIssueLocation(String docIssueLocation) {
        this.docIssueLocation = docIssueLocation;
    }

    /** 
     * Get the 'DocID' attribute value. Unique number assigned by authorities to document.
     * 
     * @return value
     */
    public String getDocID() {
        return docID;
    }

    /** 
     * Set the 'DocID' attribute value. Unique number assigned by authorities to document.
     * 
     * @param docID
     */
    public void setDocID(String docID) {
        this.docID = docID;
    }

    /** 
     * Get the 'DocTypeCode' attribute value. Indicates the type of document (e.g. Passport, Military ID, Drivers License, national ID, Vaccination Certificate). Refer to OTA Code List Document Type (DOC).
     * 
     * @return value
     */
    public String getDocTypeCode() {
        return docTypeCode;
    }

    /** 
     * Set the 'DocTypeCode' attribute value. Indicates the type of document (e.g. Passport, Military ID, Drivers License, national ID, Vaccination Certificate). Refer to OTA Code List Document Type (DOC).
     * 
     * @param docTypeCode
     */
    public void setDocTypeCode(String docTypeCode) {
        this.docTypeCode = docTypeCode;
    }

    /** 
     * Get the 'BirthDate' attribute value.
     * 
     * @return value
     */
    public Date getBirthDate() {
        return birthDate;
    }

    /** 
     * Set the 'BirthDate' attribute value.
     * 
     * @param birthDate
     */
    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    /** 
     * Get the 'EffectiveDate' attribute value. Indicates the starting date.
     * 
     * @return value
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' attribute value. Indicates the starting date.
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'ExpireDate' attribute value. Indicates the ending date.
     * 
     * @return value
     */
    public Date getExpireDate() {
        return expireDate;
    }

    /** 
     * Set the 'ExpireDate' attribute value. Indicates the ending date.
     * 
     * @param expireDate
     */
    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    /** 
     * Get the 'DocIssueCountryCode' attribute value. Country where the document was issued.
     * 
     * @return value
     */
    public String getDocIssueCountryCode() {
        return docIssueCountryCode;
    }

    /** 
     * Set the 'DocIssueCountryCode' attribute value. Country where the document was issued.
     * 
     * @param docIssueCountryCode
     */
    public void setDocIssueCountryCode(String docIssueCountryCode) {
        this.docIssueCountryCode = docIssueCountryCode;
    }

    /** 
     * Get the 'BirthPlace' attribute value. Specifies the birth place of the document holder.
     * 
     * @return value
     */
    public String getBirthPlace() {
        return birthPlace;
    }

    /** 
     * Set the 'BirthPlace' attribute value. Specifies the birth place of the document holder.
     * 
     * @param birthPlace
     */
    public void setBirthPlace(String birthPlace) {
        this.birthPlace = birthPlace;
    }

    /** 
     * Get the 'BirthCountryCode' attribute value. Specifies the birth country of the document holder.
     * 
     * @return value
     */
    public String getBirthCountryCode() {
        return birthCountryCode;
    }

    /** 
     * Set the 'BirthCountryCode' attribute value. Specifies the birth country of the document holder.
     * 
     * @param birthCountryCode
     */
    public void setBirthCountryCode(String birthCountryCode) {
        this.birthCountryCode = birthCountryCode;
    }

    /** 
     * Get the 'DocHolderNationalityCode' attribute value. The country code of the nationality of the document holder.
     * 
     * @return value
     */
    public String getDocHolderNationalityCode() {
        return docHolderNationalityCode;
    }

    /** 
     * Set the 'DocHolderNationalityCode' attribute value. The country code of the nationality of the document holder.
     * 
     * @param docHolderNationalityCode
     */
    public void setDocHolderNationalityCode(String docHolderNationalityCode) {
        this.docHolderNationalityCode = docHolderNationalityCode;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'VIT_LineType' attribute value.
     * 
     * @return value
     */
    public VITStarLineType getVITLineType() {
        return VITLineType;
    }

    /** 
     * Set the 'VIT_LineType' attribute value.
     * 
     * @param VITLineType
     */
    public void setVITLineType(VITStarLineType VITLineType) {
        this.VITLineType = VITLineType;
    }

    /** 
     * Get the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @return value
     */
    public String getVITSecondaryQualifier() {
        return VITSecondaryQualifier;
    }

    /** 
     * Set the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @param VITSecondaryQualifier
     */
    public void setVITSecondaryQualifier(String VITSecondaryQualifier) {
        this.VITSecondaryQualifier = VITSecondaryQualifier;
    }

    /** 
     * Get the 'VIT_OrderNmbr' attribute value.
     * 
     * @return value
     */
    public String getVITOrderNmbr() {
        return VITOrderNmbr;
    }

    /** 
     * Set the 'VIT_OrderNmbr' attribute value.
     * 
     * @param VITOrderNmbr
     */
    public void setVITOrderNmbr(String VITOrderNmbr) {
        this.VITOrderNmbr = VITOrderNmbr;
    }

    /** 
     * Get the 'GenderCode' attribute value.
     * 
     * @return value
     */
    public String getGenderCode() {
        return genderCode;
    }

    /** 
     * Set the 'GenderCode' attribute value.
     * 
     * @param genderCode
     */
    public void setGenderCode(String genderCode) {
        this.genderCode = genderCode;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a Document
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a Document
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'IsUsedForSecureFlightRules' attribute value.
     * 
     * @return value
     */
    public YesNoType getIsUsedForSecureFlightRules() {
        return isUsedForSecureFlightRules;
    }

    /** 
     * Set the 'IsUsedForSecureFlightRules' attribute value.
     * 
     * @param isUsedForSecureFlightRules
     */
    public void setIsUsedForSecureFlightRules(
            YesNoType isUsedForSecureFlightRules) {
        this.isUsedForSecureFlightRules = isUsedForSecureFlightRules;
    }
}
