
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Provides address information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DupChkAddressType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0" maxOccurs="4"/>
 *     &lt;xs:element type="xs:string" name="MailStop" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CityName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PostalCd" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StateCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DupChkAddressType implements Serializable
{
    private List<String> addressLineList = new ArrayList<String>();
    private String mailStop;
    private String cityName;
    private String postalCd;
    private String stateCode;
    private String countryCode;

    /** 
     * Get the list of 'AddressLine' element items. When the address is unformatted (FormattedInd="false") these lines will contain free form address details. When the address is formatted and street number and street name must be sent independently, the street number will be sent using StreetNmbr, and the street name will be sent in the first AddressLine occurrence.
     * 
     * @return list
     */
    public List<String> getAddressLineList() {
        return addressLineList;
    }

    /** 
     * Set the list of 'AddressLine' element items. When the address is unformatted (FormattedInd="false") these lines will contain free form address details. When the address is formatted and street number and street name must be sent independently, the street number will be sent using StreetNmbr, and the street name will be sent in the first AddressLine occurrence.
     * 
     * @param list
     */
    public void setAddressLineList(List<String> list) {
        addressLineList = list;
    }

    /** 
     * Get the 'MailStop' element value. Company Mail Stop/Drop
     * 
     * @return value
     */
    public String getMailStop() {
        return mailStop;
    }

    /** 
     * Set the 'MailStop' element value. Company Mail Stop/Drop
     * 
     * @param mailStop
     */
    public void setMailStop(String mailStop) {
        this.mailStop = mailStop;
    }

    /** 
     * Get the 'CityName' element value. City (e.g., Dublin), town, or postal station (i.e., a postal service territory, often used in a military address).
     * 
     * @return value
     */
    public String getCityName() {
        return cityName;
    }

    /** 
     * Set the 'CityName' element value. City (e.g., Dublin), town, or postal station (i.e., a postal service territory, often used in a military address).
     * 
     * @param cityName
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /** 
     * Get the 'PostalCd' element value. Post Office Code number.
     * 
     * @return value
     */
    public String getPostalCd() {
        return postalCd;
    }

    /** 
     * Set the 'PostalCd' element value. Post Office Code number.
     * 
     * @param postalCd
     */
    public void setPostalCd(String postalCd) {
        this.postalCd = postalCd;
    }

    /** 
     * Get the 'StateCode' element value. State or Province Code based on Postal Information(e.g., TX for Texas).
     * 
     * @return value
     */
    public String getStateCode() {
        return stateCode;
    }

    /** 
     * Set the 'StateCode' element value. State or Province Code based on Postal Information(e.g., TX for Texas).
     * 
     * @param stateCode
     */
    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }

    /** 
     * Get the 'CountryCode' element value. Country name  as a Code (e.g., US or USA for United States of America).
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value. Country name  as a Code (e.g., US or USA for United States of America).
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }
}
