
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DupChkParsedPhoneNumberType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="CountryCd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AreaCd"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="PhoneNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Extension"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DupChkParsedPhoneNumberType implements Serializable
{
    private String countryCd;
    private String areaCd;
    private String phoneNumber;
    private String extension;

    /** 
     * Get the 'CountryCd' attribute value. Code assigned by telecommunications authorities for international country access identifier.
     * 
     * @return value
     */
    public String getCountryCd() {
        return countryCd;
    }

    /** 
     * Set the 'CountryCd' attribute value. Code assigned by telecommunications authorities for international country access identifier.
     * 
     * @param countryCd
     */
    public void setCountryCd(String countryCd) {
        this.countryCd = countryCd;
    }

    /** 
     * Get the 'AreaCd' attribute value. Code assigned for telephones in a specific region, city, or area.
     * 
     * @return value
     */
    public String getAreaCd() {
        return areaCd;
    }

    /** 
     * Set the 'AreaCd' attribute value. Code assigned for telephones in a specific region, city, or area.
     * 
     * @param areaCd
     */
    public void setAreaCd(String areaCd) {
        this.areaCd = areaCd;
    }

    /** 
     * Get the 'PhoneNumber' attribute value. Parsed Telephone  number assigned to a single location.
     * 
     * @return value
     */
    public String getPhoneNumber() {
        return phoneNumber;
    }

    /** 
     * Set the 'PhoneNumber' attribute value. Parsed Telephone  number assigned to a single location.
     * 
     * @param phoneNumber
     */
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /** 
     * Get the 'Extension' attribute value. Extension to reach a specific party at the phone number.
     * 
     * @return value
     */
    public String getExtension() {
        return extension;
    }

    /** 
     * Set the 'Extension' attribute value. Extension to reach a specific party at the phone number.
     * 
     * @param extension
     */
    public void setExtension(String extension) {
        this.extension = extension;
    }
}
