
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DupChkTelephoneType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice>
 *       &lt;xs:element type="xs:string" name="FullPhoneNumber"/>
 *       &lt;xs:element type="ns:DupChkRSParsedPhoneNumberType" name="ParsedPhoneNumber"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DupChkTelephoneType implements Serializable
{
    private int choiceSelect = -1;
    private static final int FULL_PHONE_NUMBER_CHOICE = 0;
    private static final int PARSED_PHONE_NUMBER_CHOICE = 1;
    private String fullPhoneNumber;
    private DupChkRSParsedPhoneNumberType parsedPhoneNumber;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if FullPhoneNumber is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFullPhoneNumber() {
        return choiceSelect == FULL_PHONE_NUMBER_CHOICE;
    }

    /** 
     * Get the 'FullPhoneNumber' element value.
     * 
     * @return value
     */
    public String getFullPhoneNumber() {
        return fullPhoneNumber;
    }

    /** 
     * Set the 'FullPhoneNumber' element value.
     * 
     * @param fullPhoneNumber
     */
    public void setFullPhoneNumber(String fullPhoneNumber) {
        setChoiceSelect(FULL_PHONE_NUMBER_CHOICE);
        this.fullPhoneNumber = fullPhoneNumber;
    }

    /** 
     * Check if ParsedPhoneNumber is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifParsedPhoneNumber() {
        return choiceSelect == PARSED_PHONE_NUMBER_CHOICE;
    }

    /** 
     * Get the 'ParsedPhoneNumber' element value.
     * 
     * @return value
     */
    public DupChkRSParsedPhoneNumberType getParsedPhoneNumber() {
        return parsedPhoneNumber;
    }

    /** 
     * Set the 'ParsedPhoneNumber' element value.
     * 
     * @param parsedPhoneNumber
     */
    public void setParsedPhoneNumber(
            DupChkRSParsedPhoneNumberType parsedPhoneNumber) {
        setChoiceSelect(PARSED_PHONE_NUMBER_CHOICE);
        this.parsedPhoneNumber = parsedPhoneNumber;
    }
}
