
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DupChkTravelerProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DupChkPersonNameType" name="PersonName" maxOccurs="5"/>
 *     &lt;xs:element type="ns:DupChkTelephoneType" name="Telephone" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:DupChkEmailType" name="Email" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:DupChkAddressType" name="Address" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="xs:date" name="BirthDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GenderCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DupChkTravelerProfileType implements Serializable
{
    private List<DupChkPersonNameType> personNameList = new ArrayList<DupChkPersonNameType>();
    private List<DupChkTelephoneType> telephoneList = new ArrayList<DupChkTelephoneType>();
    private List<DupChkEmailType> emailList = new ArrayList<DupChkEmailType>();
    private List<DupChkAddressType> addressList = new ArrayList<DupChkAddressType>();
    private Date birthDate;
    private String genderCode;

    /** 
     * Get the list of 'PersonName' element items. ***OTA Based *** Person Name Information 
     * 
     * @return list
     */
    public List<DupChkPersonNameType> getPersonNameList() {
        return personNameList;
    }

    /** 
     * Set the list of 'PersonName' element items. ***OTA Based *** Person Name Information 
     * 
     * @param list
     */
    public void setPersonNameList(List<DupChkPersonNameType> list) {
        personNameList = list;
    }

    /** 
     * Get the list of 'Telephone' element items. ***OTA Based *** Telephone Information 
     * 
     * @return list
     */
    public List<DupChkTelephoneType> getTelephoneList() {
        return telephoneList;
    }

    /** 
     * Set the list of 'Telephone' element items. ***OTA Based *** Telephone Information 
     * 
     * @param list
     */
    public void setTelephoneList(List<DupChkTelephoneType> list) {
        telephoneList = list;
    }

    /** 
     * Get the list of 'Email' element items. ***OTA Based *** Email Information 
     * 
     * @return list
     */
    public List<DupChkEmailType> getEmailList() {
        return emailList;
    }

    /** 
     * Set the list of 'Email' element items. ***OTA Based *** Email Information 
     * 
     * @param list
     */
    public void setEmailList(List<DupChkEmailType> list) {
        emailList = list;
    }

    /** 
     * Get the list of 'Address' element items. ***OTA Based *** Address Information 
     * 
     * @return list
     */
    public List<DupChkAddressType> getAddressList() {
        return addressList;
    }

    /** 
     * Set the list of 'Address' element items. ***OTA Based *** Address Information 
     * 
     * @param list
     */
    public void setAddressList(List<DupChkAddressType> list) {
        addressList = list;
    }

    /** 
     * Get the 'BirthDate' element value. Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
     * 
     * @return value
     */
    public Date getBirthDate() {
        return birthDate;
    }

    /** 
     * Set the 'BirthDate' element value. Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
     * 
     * @param birthDate
     */
    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    /** 
     * Get the 'GenderCode' element value.
     * 
     * @return value
     */
    public String getGenderCode() {
        return genderCode;
    }

    /** 
     * Set the 'GenderCode' element value.
     * 
     * @param genderCode
     */
    public void setGenderCode(String genderCode) {
        this.genderCode = genderCode;
    }
}
