
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Electronic email addresses, in IETF specified format.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EmailType">
 *   &lt;xs:sequence minOccurs="0">
 *     &lt;!-- Reference to inner class Sequence -->
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EmailTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EmailUsageCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FormatTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="EmailAddress"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PurposeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LanguageIDCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EmailRemark"/>
 *   &lt;xs:attribute type="ns:VIT_StarLineType" use="optional" name="VIT_LineType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_SecondaryQualifier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_OrderNmbr"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class EmailType implements Serializable
{
    private Sequence dataSource;
    private String emailTypeCode;
    private String emailUsageCode;
    private String formatTypeCode;
    private String emailAddress;
    private String purposeCode;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String languageIDCode;
    private String emailRemark;
    private VITStarLineType VITLineType;
    private String VITSecondaryQualifier;
    private String VITOrderNmbr;

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getDataSource() {
        return dataSource;
    }

    /** 
     * Set the sequence value.
     * 
     * @param dataSource
     */
    public void setDataSource(Sequence dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'EmailTypeCode' attribute value.
     * 
     * @return value
     */
    public String getEmailTypeCode() {
        return emailTypeCode;
    }

    /** 
     * Set the 'EmailTypeCode' attribute value.
     * 
     * @param emailTypeCode
     */
    public void setEmailTypeCode(String emailTypeCode) {
        this.emailTypeCode = emailTypeCode;
    }

    /** 
     * Get the 'EmailUsageCode' attribute value.
     * 
     * @return value
     */
    public String getEmailUsageCode() {
        return emailUsageCode;
    }

    /** 
     * Set the 'EmailUsageCode' attribute value.
     * 
     * @param emailUsageCode
     */
    public void setEmailUsageCode(String emailUsageCode) {
        this.emailUsageCode = emailUsageCode;
    }

    /** 
     * Get the 'FormatTypeCode' attribute value.
     * 
     * @return value
     */
    public String getFormatTypeCode() {
        return formatTypeCode;
    }

    /** 
     * Set the 'FormatTypeCode' attribute value.
     * 
     * @param formatTypeCode
     */
    public void setFormatTypeCode(String formatTypeCode) {
        this.formatTypeCode = formatTypeCode;
    }

    /** 
     * Get the 'EmailAddress' attribute value.
     * 
     * @return value
     */
    public String getEmailAddress() {
        return emailAddress;
    }

    /** 
     * Set the 'EmailAddress' attribute value.
     * 
     * @param emailAddress
     */
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    /** 
     * Get the 'PurposeCode' attribute value. Identifies the Purpose Code
     * 
     * @return value
     */
    public String getPurposeCode() {
        return purposeCode;
    }

    /** 
     * Set the 'PurposeCode' attribute value. Identifies the Purpose Code
     * 
     * @param purposeCode
     */
    public void setPurposeCode(String purposeCode) {
        this.purposeCode = purposeCode;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'LanguageIDCode' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @return value
     */
    public String getLanguageIDCode() {
        return languageIDCode;
    }

    /** 
     * Set the 'LanguageIDCode' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @param languageIDCode
     */
    public void setLanguageIDCode(String languageIDCode) {
        this.languageIDCode = languageIDCode;
    }

    /** 
     * Get the 'EmailRemark' attribute value.
     * 
     * @return value
     */
    public String getEmailRemark() {
        return emailRemark;
    }

    /** 
     * Set the 'EmailRemark' attribute value.
     * 
     * @param emailRemark
     */
    public void setEmailRemark(String emailRemark) {
        this.emailRemark = emailRemark;
    }

    /** 
     * Get the 'VIT_LineType' attribute value.
     * 
     * @return value
     */
    public VITStarLineType getVITLineType() {
        return VITLineType;
    }

    /** 
     * Set the 'VIT_LineType' attribute value.
     * 
     * @param VITLineType
     */
    public void setVITLineType(VITStarLineType VITLineType) {
        this.VITLineType = VITLineType;
    }

    /** 
     * Get the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @return value
     */
    public String getVITSecondaryQualifier() {
        return VITSecondaryQualifier;
    }

    /** 
     * Set the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @param VITSecondaryQualifier
     */
    public void setVITSecondaryQualifier(String VITSecondaryQualifier) {
        this.VITSecondaryQualifier = VITSecondaryQualifier;
    }

    /** 
     * Get the 'VIT_OrderNmbr' attribute value.
     * 
     * @return value
     */
    public String getVITOrderNmbr() {
        return VITOrderNmbr;
    }

    /** 
     * Set the 'VIT_OrderNmbr' attribute value.
     * 
     * @param VITOrderNmbr
     */
    public void setVITOrderNmbr(String VITOrderNmbr) {
        this.VITOrderNmbr = VITOrderNmbr;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
     *   &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
     *   &lt;xs:element type="xs:string" name="ContactRemark" minOccurs="0"/>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private DataSourceInfoType dataSource;
        private TransactionalDataType transactionalData;
        private String contactRemark;

        /** 
         * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
         * 
         * @return value
         */
        public DataSourceInfoType getDataSource() {
            return dataSource;
        }

        /** 
         * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
         * 
         * @param dataSource
         */
        public void setDataSource(DataSourceInfoType dataSource) {
            this.dataSource = dataSource;
        }

        /** 
         * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
         * 
         * @return value
         */
        public TransactionalDataType getTransactionalData() {
            return transactionalData;
        }

        /** 
         * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
         * 
         * @param transactionalData
         */
        public void setTransactionalData(TransactionalDataType transactionalData) {
            this.transactionalData = transactionalData;
        }

        /** 
         * Get the 'ContactRemark' element value. *** SABRE ADDED ***
        Additional information about the contact person.
         * 
         * @return value
         */
        public String getContactRemark() {
            return contactRemark;
        }

        /** 
         * Set the 'ContactRemark' element value. *** SABRE ADDED ***
        Additional information about the contact person.
         * 
         * @param contactRemark
         */
        public void setContactRemark(String contactRemark) {
            this.contactRemark = contactRemark;
        }
    }
}
