
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Added by Sabre
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExtractRSTPAIdentityType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ExtractRSLoginType" name="Login" minOccurs="0"/>
 *     &lt;xs:element type="ns:ProfileSubTypeType" name="ProfileSubType" minOccurs="0" maxOccurs="5"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="UniqueID"/>
 *   &lt;xs:attribute type="ns:ProfileTypeInfo" use="required" name="ProfileTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProfileName"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ExtractRSTPAIdentityType implements Serializable
{
    private ExtractRSLoginType login;
    private List<ProfileSubTypeType> profileSubTypeList = new ArrayList<ProfileSubTypeType>();
    private String uniqueID;
    private ProfileTypeInfo profileTypeCode;
    private String profileName;
    private String domainID;

    /** 
     * Get the 'Login' element value.
     * 
     * @return value
     */
    public ExtractRSLoginType getLogin() {
        return login;
    }

    /** 
     * Set the 'Login' element value.
     * 
     * @param login
     */
    public void setLogin(ExtractRSLoginType login) {
        this.login = login;
    }

    /** 
     * Get the list of 'ProfileSubType' element items.
     * 
     * @return list
     */
    public List<ProfileSubTypeType> getProfileSubTypeList() {
        return profileSubTypeList;
    }

    /** 
     * Set the list of 'ProfileSubType' element items.
     * 
     * @param list
     */
    public void setProfileSubTypeList(List<ProfileSubTypeType> list) {
        profileSubTypeList = list;
    }

    /** 
     * Get the 'UniqueID' attribute value.
     * 
     * @return value
     */
    public String getUniqueID() {
        return uniqueID;
    }

    /** 
     * Set the 'UniqueID' attribute value.
     * 
     * @param uniqueID
     */
    public void setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    /** 
     * Get the 'ProfileTypeCode' attribute value.
     * 
     * @return value
     */
    public ProfileTypeInfo getProfileTypeCode() {
        return profileTypeCode;
    }

    /** 
     * Set the 'ProfileTypeCode' attribute value.
     * 
     * @param profileTypeCode
     */
    public void setProfileTypeCode(ProfileTypeInfo profileTypeCode) {
        this.profileTypeCode = profileTypeCode;
    }

    /** 
     * Get the 'ProfileName' attribute value.
     * 
     * @return value
     */
    public String getProfileName() {
        return profileName;
    }

    /** 
     * Set the 'ProfileName' attribute value.
     * 
     * @param profileName
     */
    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    /** 
     * Get the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
    	
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
    	
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }
}
