
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Identifes an action to take place.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FieldCodeDataType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="String"/>
 *     &lt;xs:enumeration value="Integer"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum FieldCodeDataType implements Serializable {
    STRING("String"), INTEGER("Integer");
    private final String value;

    private FieldCodeDataType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static FieldCodeDataType convert(String value) {
        for (FieldCodeDataType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
