
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterCardHolderNameType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CardHolderFullName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="NamePrefix" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SurName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="NameSuffix" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterCardHolderNameType implements Serializable
{
    private String cardHolderFullName;
    private String namePrefix;
    private String givenName;
    private String middleName;
    private String surName;
    private String nameSuffix;

    /** 
     * Get the 'CardHolderFullName' element value.
     * 
     * @return value
     */
    public String getCardHolderFullName() {
        return cardHolderFullName;
    }

    /** 
     * Set the 'CardHolderFullName' element value.
     * 
     * @param cardHolderFullName
     */
    public void setCardHolderFullName(String cardHolderFullName) {
        this.cardHolderFullName = cardHolderFullName;
    }

    /** 
     * Get the 'NamePrefix' element value. Salutation of honorific. (e.g., Mr. Mrs., Ms., Miss, Dr.) 
     * 
     * @return value
     */
    public String getNamePrefix() {
        return namePrefix;
    }

    /** 
     * Set the 'NamePrefix' element value. Salutation of honorific. (e.g., Mr. Mrs., Ms., Miss, Dr.) 
     * 
     * @param namePrefix
     */
    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    /** 
     * Get the 'GivenName' element value. Given name, first name or names
     * 
     * @return value
     */
    public String getGivenName() {
        return givenName;
    }

    /** 
     * Set the 'GivenName' element value. Given name, first name or names
     * 
     * @param givenName
     */
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    /** 
     * Get the 'MiddleName' element value. The middle name of the person name
     * 
     * @return value
     */
    public String getMiddleName() {
        return middleName;
    }

    /** 
     * Set the 'MiddleName' element value. The middle name of the person name
     * 
     * @param middleName
     */
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    /** 
     * Get the 'SurName' element value. Family name, last name.
     * 
     * @return value
     */
    public String getSurName() {
        return surName;
    }

    /** 
     * Set the 'SurName' element value. Family name, last name.
     * 
     * @param surName
     */
    public void setSurName(String surName) {
        this.surName = surName;
    }

    /** 
     * Get the 'NameSuffix' element value. Hold various name suffixes and letters (e.g. Jr., Sr., III, Ret., Esq.).
     * 
     * @return value
     */
    public String getNameSuffix() {
        return nameSuffix;
    }

    /** 
     * Set the 'NameSuffix' element value. Hold various name suffixes and letters (e.g. Jr., Sr., III, Ret., Esq.).
     * 
     * @param nameSuffix
     */
    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }
}
