
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterCustLoyaltyType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SurName" minOccurs="0"/>
 *     &lt;xs:element type="ns:FilterAssociatedVendorsType" name="AssociatedVendors" minOccurs="0" maxOccurs="500"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VendorTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VendorCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MembershipID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterCustLoyaltyType implements Serializable
{
    private String givenName;
    private String middleName;
    private String surName;
    private List<FilterAssociatedVendorsType> associatedVendorList = new ArrayList<FilterAssociatedVendorsType>();
    private String vendorTypeCode;
    private String vendorCode;
    private String membershipID;
    private String displaySequenceNo;
    private String orderSequenceNo;

    /** 
     * Get the 'GivenName' element value. Given name, first name or names
     * 
     * @return value
     */
    public String getGivenName() {
        return givenName;
    }

    /** 
     * Set the 'GivenName' element value. Given name, first name or names
     * 
     * @param givenName
     */
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    /** 
     * Get the 'MiddleName' element value. The middle name of the person name
     * 
     * @return value
     */
    public String getMiddleName() {
        return middleName;
    }

    /** 
     * Set the 'MiddleName' element value. The middle name of the person name
     * 
     * @param middleName
     */
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    /** 
     * Get the 'SurName' element value. Family name, last name.
     * 
     * @return value
     */
    public String getSurName() {
        return surName;
    }

    /** 
     * Set the 'SurName' element value. Family name, last name.
     * 
     * @param surName
     */
    public void setSurName(String surName) {
        this.surName = surName;
    }

    /** 
     * Get the list of 'AssociatedVendors' element items. Family name, last name.
     * 
     * @return list
     */
    public List<FilterAssociatedVendorsType> getAssociatedVendorList() {
        return associatedVendorList;
    }

    /** 
     * Set the list of 'AssociatedVendors' element items. Family name, last name.
     * 
     * @param list
     */
    public void setAssociatedVendorList(List<FilterAssociatedVendorsType> list) {
        associatedVendorList = list;
    }

    /** 
     * Get the 'VendorTypeCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @return value
     */
    public String getVendorTypeCode() {
        return vendorTypeCode;
    }

    /** 
     * Set the 'VendorTypeCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @param vendorTypeCode
     */
    public void setVendorTypeCode(String vendorTypeCode) {
        this.vendorTypeCode = vendorTypeCode;
    }

    /** 
     * Get the 'VendorCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'MembershipID' attribute value. Unique identifier of the member in the program (membership number, account number, etc.).
     * 
     * @return value
     */
    public String getMembershipID() {
        return membershipID;
    }

    /** 
     * Set the 'MembershipID' attribute value. Unique identifier of the member in the program (membership number, account number, etc.).
     * 
     * @param membershipID
     */
    public void setMembershipID(String membershipID) {
        this.membershipID = membershipID;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }
}
