
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Customer Reference Info Data that includes info like DK Number, 3rd party system reference data 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterCustomerReferenceInfoType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="TripTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BranchID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ReferenceID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterCustomerReferenceInfoType implements Serializable
{
    private String tripTypeCode;
    private String type;
    private String branchID;
    private String referenceID;
    private String displaySequenceNo;
    private String orderSequenceNo;

    /** 
     * Get the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @return value
     */
    public String getTripTypeCode() {
        return tripTypeCode;
    }

    /** 
     * Set the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @param tripTypeCode
     */
    public void setTripTypeCode(String tripTypeCode) {
        this.tripTypeCode = tripTypeCode;
    }

    /** 
     * Get the 'Type' attribute value.
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value.
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'BranchID' attribute value. Branch Indicator that is associated to ReferenceID
     * 
     * @return value
     */
    public String getBranchID() {
        return branchID;
    }

    /** 
     * Set the 'BranchID' attribute value. Branch Indicator that is associated to ReferenceID
     * 
     * @param branchID
     */
    public void setBranchID(String branchID) {
        this.branchID = branchID;
    }

    /** 
     * Get the 'ReferenceID' attribute value.
     * 
     * @return value
     */
    public String getReferenceID() {
        return referenceID;
    }

    /** 
     * Set the 'ReferenceID' attribute value.
     * 
     * @param referenceID
     */
    public void setReferenceID(String referenceID) {
        this.referenceID = referenceID;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }
}
