
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterGovernmentWarrantType">
 *   &lt;xs:attribute type="ns:YesNoType" name="FirstRemark"/>
 *   &lt;xs:attribute type="ns:PaymentFormGovernmentWarrantTypeEnumType" use="required" name="WarrantType"/>
 *   &lt;xs:attribute type="xs:string" name="WarrantSubtype"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="WarrantNumber"/>
 *   &lt;xs:attribute type="xs:string" name="DebtorCd"/>
 *   &lt;xs:attribute type="xs:string" name="ObjectCd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterGovernmentWarrantType implements Serializable
{
    private YesNoType firstRemark;
    private PaymentFormGovernmentWarrantTypeEnumType warrantType;
    private String warrantSubtype;
    private String warrantNumber;
    private String debtorCd;
    private String objectCd;

    /** 
     * Get the 'FirstRemark' attribute value. First Remark indicator
     * 
     * @return value
     */
    public YesNoType getFirstRemark() {
        return firstRemark;
    }

    /** 
     * Set the 'FirstRemark' attribute value. First Remark indicator
     * 
     * @param firstRemark
     */
    public void setFirstRemark(YesNoType firstRemark) {
        this.firstRemark = firstRemark;
    }

    /** 
     * Get the 'WarrantType' attribute value. Warrant Type (GR,  GGR, FGR)
     * 
     * @return value
     */
    public PaymentFormGovernmentWarrantTypeEnumType getWarrantType() {
        return warrantType;
    }

    /** 
     * Set the 'WarrantType' attribute value. Warrant Type (GR,  GGR, FGR)
     * 
     * @param warrantType
     */
    public void setWarrantType(
            PaymentFormGovernmentWarrantTypeEnumType warrantType) {
        this.warrantType = warrantType;
    }

    /** 
     * Get the 'WarrantSubtype' attribute value. Warrant subtype
     * 
     * @return value
     */
    public String getWarrantSubtype() {
        return warrantSubtype;
    }

    /** 
     * Set the 'WarrantSubtype' attribute value. Warrant subtype
     * 
     * @param warrantSubtype
     */
    public void setWarrantSubtype(String warrantSubtype) {
        this.warrantSubtype = warrantSubtype;
    }

    /** 
     * Get the 'WarrantNumber' attribute value. Warrant code/ number/ identifier etc.
     * 
     * @return value
     */
    public String getWarrantNumber() {
        return warrantNumber;
    }

    /** 
     * Set the 'WarrantNumber' attribute value. Warrant code/ number/ identifier etc.
     * 
     * @param warrantNumber
     */
    public void setWarrantNumber(String warrantNumber) {
        this.warrantNumber = warrantNumber;
    }

    /** 
     * Get the 'DebtorCd' attribute value. Debtor Code represents chargeback account number. 
     * 
     * @return value
     */
    public String getDebtorCd() {
        return debtorCd;
    }

    /** 
     * Set the 'DebtorCd' attribute value. Debtor Code represents chargeback account number. 
     * 
     * @param debtorCd
     */
    public void setDebtorCd(String debtorCd) {
        this.debtorCd = debtorCd;
    }

    /** 
     * Get the 'ObjectCd' attribute value. Object Code represents the terms of this warrant - limitations on the use of the warrant, such as fees, fare, taxes, and responsibilities. 
     * 
     * @return value
     */
    public String getObjectCd() {
        return objectCd;
    }

    /** 
     * Set the 'ObjectCd' attribute value. Object Code represents the terms of this warrant - limitations on the use of the warrant, such as fees, fare, taxes, and responsibilities. 
     * 
     * @param objectCd
     */
    public void setObjectCd(String objectCd) {
        this.objectCd = objectCd;
    }
}
