
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * FilterType for BulkRead request
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterIDType">
 *   &lt;xs:attribute type="xs:string" use="required" name="FilterID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterIDType implements Serializable
{
    private String filterID;
    private String domainID;
    private String clientCode;

    /** 
     * Get the 'FilterID' attribute value. *** SABRE ADDED *** ID of the Filter in the database
     * 
     * @return value
     */
    public String getFilterID() {
        return filterID;
    }

    /** 
     * Set the 'FilterID' attribute value. *** SABRE ADDED *** ID of the Filter in the database
     * 
     * @param filterID
     */
    public void setFilterID(String filterID) {
        this.filterID = filterID;
    }

    /** 
     * Get the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
    			
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
    			
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }
}
