
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Travel Agency Profile
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterOperationalProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FilterTelephoneType" name="Telephone" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:FilterEmailType" name="Email" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:FilterAddressType" name="Address" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:FilterPaymentFormType" name="PaymentForm" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:FilterRemarkType" name="Remark" minOccurs="0" maxOccurs="1000"/>
 *     &lt;xs:element type="ns:FilterCustomerReferenceInfoType" name="CustomerReferenceInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:FilterDiscountsType" name="Discounts" minOccurs="0" maxOccurs="200"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterOperationalProfileType implements Serializable
{
    private List<FilterTelephoneType> telephoneList = new ArrayList<FilterTelephoneType>();
    private List<FilterEmailType> emailList = new ArrayList<FilterEmailType>();
    private List<FilterAddressType> addressList = new ArrayList<FilterAddressType>();
    private List<FilterPaymentFormType> paymentFormList = new ArrayList<FilterPaymentFormType>();
    private List<FilterRemarkType> remarkList = new ArrayList<FilterRemarkType>();
    private FilterCustomerReferenceInfoType customerReferenceInfo;
    private List<FilterDiscountsType> discountList = new ArrayList<FilterDiscountsType>();

    /** 
     * Get the list of 'Telephone' element items. ***OTA Based *** Telephone Information 
     * 
     * @return list
     */
    public List<FilterTelephoneType> getTelephoneList() {
        return telephoneList;
    }

    /** 
     * Set the list of 'Telephone' element items. ***OTA Based *** Telephone Information 
     * 
     * @param list
     */
    public void setTelephoneList(List<FilterTelephoneType> list) {
        telephoneList = list;
    }

    /** 
     * Get the list of 'Email' element items. ***OTA Based *** Email Information 
     * 
     * @return list
     */
    public List<FilterEmailType> getEmailList() {
        return emailList;
    }

    /** 
     * Set the list of 'Email' element items. ***OTA Based *** Email Information 
     * 
     * @param list
     */
    public void setEmailList(List<FilterEmailType> list) {
        emailList = list;
    }

    /** 
     * Get the list of 'Address' element items. ***OTA Based *** Address Information 
     * 
     * @return list
     */
    public List<FilterAddressType> getAddressList() {
        return addressList;
    }

    /** 
     * Set the list of 'Address' element items. ***OTA Based *** Address Information 
     * 
     * @param list
     */
    public void setAddressList(List<FilterAddressType> list) {
        addressList = list;
    }

    /** 
     * Get the list of 'PaymentForm' element items. ***OTA Based *** Payment Information 
     * 
     * @return list
     */
    public List<FilterPaymentFormType> getPaymentFormList() {
        return paymentFormList;
    }

    /** 
     * Set the list of 'PaymentForm' element items. ***OTA Based *** Payment Information 
     * 
     * @param list
     */
    public void setPaymentFormList(List<FilterPaymentFormType> list) {
        paymentFormList = list;
    }

    /** 
     * Get the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @return list
     */
    public List<FilterRemarkType> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @param list
     */
    public void setRemarkList(List<FilterRemarkType> list) {
        remarkList = list;
    }

    /** 
     * Get the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return value
     */
    public FilterCustomerReferenceInfoType getCustomerReferenceInfo() {
        return customerReferenceInfo;
    }

    /** 
     * Set the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param customerReferenceInfo
     */
    public void setCustomerReferenceInfo(
            FilterCustomerReferenceInfoType customerReferenceInfo) {
        this.customerReferenceInfo = customerReferenceInfo;
    }

    /** 
     * Get the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @return list
     */
    public List<FilterDiscountsType> getDiscountList() {
        return discountList;
    }

    /** 
     * Set the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @param list
     */
    public void setDiscountList(List<FilterDiscountsType> list) {
        discountList = list;
    }
}
