
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Root element for profile content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FilterTPAIdentityType" name="TPA_Identity"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterProfileType implements Serializable
{
    private FilterTPAIdentityType TPAIdentity;
    private Choice choice;

    /** 
     * Get the 'TPA_Identity' element value. ***SABRE ADDED*** To hold Identity information of a profile
     * 
     * @return value
     */
    public FilterTPAIdentityType getTPAIdentity() {
        return TPAIdentity;
    }

    /** 
     * Set the 'TPA_Identity' element value. ***SABRE ADDED*** To hold Identity information of a profile
     * 
     * @param TPAIdentity
     */
    public void setTPAIdentity(FilterTPAIdentityType TPAIdentity) {
        this.TPAIdentity = TPAIdentity;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:FilterTravelerProfileType" name="Traveler" minOccurs="0"/>
     *   &lt;xs:element type="ns:FilterTravelAgencyProfileType" name="TravelAgency" minOccurs="0"/>
     *   &lt;xs:element type="ns:FilterTravelAgentProfileType" name="TravelAgent" minOccurs="0"/>
     *   &lt;xs:element type="ns:FilterCorporateProfileType" name="Corporation" minOccurs="0"/>
     *   &lt;xs:element type="ns:FilterOperationalProfileType" name="OperationalProfile" minOccurs="0"/>
     *   &lt;xs:element type="ns:FilterGroupProfileType" name="GroupProfile" minOccurs="0"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int TRAVELER_CHOICE = 0;
        private static final int TRAVEL_AGENCY_CHOICE = 1;
        private static final int TRAVEL_AGENT_CHOICE = 2;
        private static final int CORPORATION_CHOICE = 3;
        private static final int OPERATIONAL_PROFILE_CHOICE = 4;
        private static final int GROUP_PROFILE_CHOICE = 5;
        private FilterTravelerProfileType traveler;
        private FilterTravelAgencyProfileType travelAgency;
        private FilterTravelAgentProfileType travelAgent;
        private FilterCorporateProfileType corporation;
        private FilterOperationalProfileType operationalProfile;
        private FilterGroupProfileType groupProfile;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Traveler is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTraveler() {
            return choiceSelect == TRAVELER_CHOICE;
        }

        /** 
         * Get the 'Traveler' element value. ***SABRE ADDED*** To hold Traveler Profile Information
         * 
         * @return value
         */
        public FilterTravelerProfileType getTraveler() {
            return traveler;
        }

        /** 
         * Set the 'Traveler' element value. ***SABRE ADDED*** To hold Traveler Profile Information
         * 
         * @param traveler
         */
        public void setTraveler(FilterTravelerProfileType traveler) {
            setChoiceSelect(TRAVELER_CHOICE);
            this.traveler = traveler;
        }

        /** 
         * Check if TravelAgency is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTravelAgency() {
            return choiceSelect == TRAVEL_AGENCY_CHOICE;
        }

        /** 
         * Get the 'TravelAgency' element value. ***SABRE ADDED*** To hold Travel Agency Profile 
         * 
         * @return value
         */
        public FilterTravelAgencyProfileType getTravelAgency() {
            return travelAgency;
        }

        /** 
         * Set the 'TravelAgency' element value. ***SABRE ADDED*** To hold Travel Agency Profile 
         * 
         * @param travelAgency
         */
        public void setTravelAgency(FilterTravelAgencyProfileType travelAgency) {
            setChoiceSelect(TRAVEL_AGENCY_CHOICE);
            this.travelAgency = travelAgency;
        }

        /** 
         * Check if TravelAgent is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTravelAgent() {
            return choiceSelect == TRAVEL_AGENT_CHOICE;
        }

        /** 
         * Get the 'TravelAgent' element value. ***SABRE ADDED*** To hold Travel Agent Profile 
         * 
         * @return value
         */
        public FilterTravelAgentProfileType getTravelAgent() {
            return travelAgent;
        }

        /** 
         * Set the 'TravelAgent' element value. ***SABRE ADDED*** To hold Travel Agent Profile 
         * 
         * @param travelAgent
         */
        public void setTravelAgent(FilterTravelAgentProfileType travelAgent) {
            setChoiceSelect(TRAVEL_AGENT_CHOICE);
            this.travelAgent = travelAgent;
        }

        /** 
         * Check if Corporation is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCorporation() {
            return choiceSelect == CORPORATION_CHOICE;
        }

        /** 
         * Get the 'Corporation' element value. ***SABRE ADDED*** To hold Corporation Profile 
         * 
         * @return value
         */
        public FilterCorporateProfileType getCorporation() {
            return corporation;
        }

        /** 
         * Set the 'Corporation' element value. ***SABRE ADDED*** To hold Corporation Profile 
         * 
         * @param corporation
         */
        public void setCorporation(FilterCorporateProfileType corporation) {
            setChoiceSelect(CORPORATION_CHOICE);
            this.corporation = corporation;
        }

        /** 
         * Check if OperationalProfile is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOperationalProfile() {
            return choiceSelect == OPERATIONAL_PROFILE_CHOICE;
        }

        /** 
         * Get the 'OperationalProfile' element value. ***SABRE ADDED*** To hold Operational Profiles data 
         * 
         * @return value
         */
        public FilterOperationalProfileType getOperationalProfile() {
            return operationalProfile;
        }

        /** 
         * Set the 'OperationalProfile' element value. ***SABRE ADDED*** To hold Operational Profiles data 
         * 
         * @param operationalProfile
         */
        public void setOperationalProfile(
                FilterOperationalProfileType operationalProfile) {
            setChoiceSelect(OPERATIONAL_PROFILE_CHOICE);
            this.operationalProfile = operationalProfile;
        }

        /** 
         * Check if GroupProfile is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifGroupProfile() {
            return choiceSelect == GROUP_PROFILE_CHOICE;
        }

        /** 
         * Get the 'GroupProfile' element value. ***SABRE ADDED*** To hold Group Profile 
         * 
         * @return value
         */
        public FilterGroupProfileType getGroupProfile() {
            return groupProfile;
        }

        /** 
         * Set the 'GroupProfile' element value. ***SABRE ADDED*** To hold Group Profile 
         * 
         * @param groupProfile
         */
        public void setGroupProfile(FilterGroupProfileType groupProfile) {
            setChoiceSelect(GROUP_PROFILE_CHOICE);
            this.groupProfile = groupProfile;
        }
    }
}
