
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Root element for Filter content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FilterType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FilterProfileType" name="Profile"/>
 *     &lt;xs:element type="ns:FilterAssociatedProfilesType" name="AssociatedProfiles" minOccurs="0" maxOccurs="500"/>
 *     &lt;xs:element type="ns:AssociatedFormatsType" name="AssociatedFormats" minOccurs="0" maxOccurs="500"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="FilterID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="FilterName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FilterDescription"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MainProfileOrderSeqNo"/>
 *   &lt;xs:attribute type="xs:dateTime" use="required" name="CreateDateTime"/>
 *   &lt;xs:attribute type="xs:dateTime" use="required" name="UpdateDateTime"/>
 *   &lt;xs:attribute type="ns:StatusType" use="optional" name="FilterStatusCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FilterPurgeNoOfDays"/>
 *   &lt;xs:attribute type="ns:ProfileTypeInfo" use="required" name="FilterTypeCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FilterType implements Serializable
{
    private FilterProfileType profile;
    private List<FilterAssociatedProfilesType> associatedProfileList = new ArrayList<FilterAssociatedProfilesType>();
    private List<AssociatedFormatsType> associatedFormatList = new ArrayList<AssociatedFormatsType>();
    private String filterID;
    private String domainID;
    private String clientCode;
    private String clientContextCode;
    private String filterName;
    private String filterDescription;
    private String mainProfileOrderSeqNo;
    private Date createDateTime;
    private Date updateDateTime;
    private StatusType filterStatusCode;
    private String filterPurgeNoOfDays;
    private ProfileTypeInfo filterTypeCode;

    /** 
     * Get the 'Profile' element value. *** OTA Based *** Filter Strucutre of a profile data 
     * 
     * @return value
     */
    public FilterProfileType getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value. *** OTA Based *** Filter Strucutre of a profile data 
     * 
     * @param profile
     */
    public void setProfile(FilterProfileType profile) {
        this.profile = profile;
    }

    /** 
     * Get the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** Profiles Associated to a Template
     * 
     * @return list
     */
    public List<FilterAssociatedProfilesType> getAssociatedProfileList() {
        return associatedProfileList;
    }

    /** 
     * Set the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** Profiles Associated to a Template
     * 
     * @param list
     */
    public void setAssociatedProfileList(List<FilterAssociatedProfilesType> list) {
        associatedProfileList = list;
    }

    /** 
     * Get the list of 'AssociatedFormats' element items. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @return list
     */
    public List<AssociatedFormatsType> getAssociatedFormatList() {
        return associatedFormatList;
    }

    /** 
     * Set the list of 'AssociatedFormats' element items. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @param list
     */
    public void setAssociatedFormatList(List<AssociatedFormatsType> list) {
        associatedFormatList = list;
    }

    /** 
     * Get the 'FilterID' attribute value. *** SABRE ADDED *** ID of the Filter in the database
     * 
     * @return value
     */
    public String getFilterID() {
        return filterID;
    }

    /** 
     * Set the 'FilterID' attribute value. *** SABRE ADDED *** ID of the Filter in the database
     * 
     * @param filterID
     */
    public void setFilterID(String filterID) {
        this.filterID = filterID;
    }

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'FilterName' attribute value.
     * 
     * @return value
     */
    public String getFilterName() {
        return filterName;
    }

    /** 
     * Set the 'FilterName' attribute value.
     * 
     * @param filterName
     */
    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    /** 
     * Get the 'FilterDescription' attribute value.
     * 
     * @return value
     */
    public String getFilterDescription() {
        return filterDescription;
    }

    /** 
     * Set the 'FilterDescription' attribute value.
     * 
     * @param filterDescription
     */
    public void setFilterDescription(String filterDescription) {
        this.filterDescription = filterDescription;
    }

    /** 
     * Get the 'MainProfileOrderSeqNo' attribute value.
     * 
     * @return value
     */
    public String getMainProfileOrderSeqNo() {
        return mainProfileOrderSeqNo;
    }

    /** 
     * Set the 'MainProfileOrderSeqNo' attribute value.
     * 
     * @param mainProfileOrderSeqNo
     */
    public void setMainProfileOrderSeqNo(String mainProfileOrderSeqNo) {
        this.mainProfileOrderSeqNo = mainProfileOrderSeqNo;
    }

    /** 
     * Get the 'CreateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @return value
     */
    public Date getCreateDateTime() {
        return createDateTime;
    }

    /** 
     * Set the 'CreateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @param createDateTime
     */
    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    /** 
     * Get the 'UpdateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @return value
     */
    public Date getUpdateDateTime() {
        return updateDateTime;
    }

    /** 
     * Set the 'UpdateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @param updateDateTime
     */
    public void setUpdateDateTime(Date updateDateTime) {
        this.updateDateTime = updateDateTime;
    }

    /** 
     * Get the 'FilterStatusCode' attribute value.
     * 
     * @return value
     */
    public StatusType getFilterStatusCode() {
        return filterStatusCode;
    }

    /** 
     * Set the 'FilterStatusCode' attribute value.
     * 
     * @param filterStatusCode
     */
    public void setFilterStatusCode(StatusType filterStatusCode) {
        this.filterStatusCode = filterStatusCode;
    }

    /** 
     * Get the 'FilterPurgeNoOfDays' attribute value. Number of days after which the Template should be purged
    	
     * 
     * @return value
     */
    public String getFilterPurgeNoOfDays() {
        return filterPurgeNoOfDays;
    }

    /** 
     * Set the 'FilterPurgeNoOfDays' attribute value. Number of days after which the Template should be purged
    	
     * 
     * @param filterPurgeNoOfDays
     */
    public void setFilterPurgeNoOfDays(String filterPurgeNoOfDays) {
        this.filterPurgeNoOfDays = filterPurgeNoOfDays;
    }

    /** 
     * Get the 'FilterTypeCode' attribute value.
     * 
     * @return value
     */
    public ProfileTypeInfo getFilterTypeCode() {
        return filterTypeCode;
    }

    /** 
     * Set the 'FilterTypeCode' attribute value.
     * 
     * @param filterTypeCode
     */
    public void setFilterTypeCode(ProfileTypeInfo filterTypeCode) {
        this.filterTypeCode = filterTypeCode;
    }
}
