
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Root element for Format content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FormatType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:SearchFormatIdentityType">
 *       &lt;xs:attribute type="xs:string" use="optional" name="FormatData"/>
 *       &lt;xs:attribute type="xs:dateTime" use="required" name="CreateDateTime"/>
 *       &lt;xs:attribute type="xs:dateTime" use="required" name="UpdateDateTime"/>
 *       &lt;xs:attribute type="ns:StatusType" use="optional" name="FormatStatusCode"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="FormatPurgeNoOfDays"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FormatType extends SearchFormatIdentityType implements
    Serializable
{
    private String formatData;
    private Date createDateTime;
    private Date updateDateTime;
    private StatusType formatStatusCode;
    private String formatPurgeNoOfDays;

    /** 
     * Get the 'FormatData' attribute value. *** SABRE ADDED ***
     * 
     * @return value
     */
    public String getFormatData() {
        return formatData;
    }

    /** 
     * Set the 'FormatData' attribute value. *** SABRE ADDED ***
     * 
     * @param formatData
     */
    public void setFormatData(String formatData) {
        this.formatData = formatData;
    }

    /** 
     * Get the 'CreateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @return value
     */
    public Date getCreateDateTime() {
        return createDateTime;
    }

    /** 
     * Set the 'CreateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @param createDateTime
     */
    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    /** 
     * Get the 'UpdateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @return value
     */
    public Date getUpdateDateTime() {
        return updateDateTime;
    }

    /** 
     * Set the 'UpdateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @param updateDateTime
     */
    public void setUpdateDateTime(Date updateDateTime) {
        this.updateDateTime = updateDateTime;
    }

    /** 
     * Get the 'FormatStatusCode' attribute value.
     * 
     * @return value
     */
    public StatusType getFormatStatusCode() {
        return formatStatusCode;
    }

    /** 
     * Set the 'FormatStatusCode' attribute value.
     * 
     * @param formatStatusCode
     */
    public void setFormatStatusCode(StatusType formatStatusCode) {
        this.formatStatusCode = formatStatusCode;
    }

    /** 
     * Get the 'FormatPurgeNoOfDays' attribute value. Number of days after which the Template should be purged
    	
     * 
     * @return value
     */
    public String getFormatPurgeNoOfDays() {
        return formatPurgeNoOfDays;
    }

    /** 
     * Set the 'FormatPurgeNoOfDays' attribute value. Number of days after which the Template should be purged
    	
     * 
     * @param formatPurgeNoOfDays
     */
    public void setFormatPurgeNoOfDays(String formatPurgeNoOfDays) {
        this.formatPurgeNoOfDays = formatPurgeNoOfDays;
    }
}
