
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Corporate profiles subject areas tracked in history
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HistoryCorporationSubjectAreaType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:TPAIdentityType" name="TPA_Identity"/>
 *     &lt;xs:element type="ns:CorporateInfoType" name="CorporateInfo"/>
 *     &lt;xs:element type="ns:ContactNameType" name="ContactName"/>
 *     &lt;xs:element type="ns:AddressType" name="Address"/>
 *     &lt;xs:element type="ns:TelephoneType" name="Telephone"/>
 *     &lt;xs:element type="ns:EmailType" name="Email"/>
 *     &lt;xs:element type="ns:PaymentFormType" name="PaymentForm"/>
 *     &lt;xs:element type="ns:ContactType" name="EmergencyContactPerson"/>
 *     &lt;xs:element type="ns:PriorityRemarksType" name="PriorityRemarks"/>
 *     &lt;xs:element type="ns:RemarkType" name="Remark"/>
 *     &lt;xs:element type="ns:GDSType" name="GDS"/>
 *     &lt;xs:element type="ns:CustomerReferenceInfoType" name="CustomerReferenceInfo"/>
 *     &lt;xs:element type="ns:SSRType" name="SSR"/>
 *     &lt;xs:element type="ns:OSIType" name="OSI"/>
 *     &lt;xs:element type="ns:BusinessSystemIdentityInfoType" name="BusinessSystemIdentityInfo"/>
 *     &lt;xs:element type="ns:AssociatedProfilesType" name="AssociatedProfiles"/>
 *     &lt;xs:element type="ns:AssociatedFiltersType" name="AssociatedFilters"/>
 *     &lt;xs:element type="ns:AssociatedTemplateType" name="AssociatedTemplate"/>
 *     &lt;xs:element type="ns:AssociatedFormatsType" name="AssociatedFormats"/>
 *     &lt;xs:element type="ns:DiscountsType" name="Discounts"/>
 *     &lt;xs:element type="ns:CustomDefinedDataType" name="CustomDefinedData"/>
 *     &lt;xs:element type="ns:TravelPolicyType" name="TravelPolicy"/>
 *     &lt;xs:element type="ns:BrandingType" name="Branding"/>
 *     &lt;xs:element type="ns:STARDataType" name="STARData"/>
 *     &lt;xs:element type="ns:BusinessTravelerSettingType" name="BusinessTravelerSetting"/>
 *     &lt;xs:element type="ns:EmploymentInfoType" name="EmploymentInfo"/>
 *     &lt;xs:element type="ns:AirlinePrefType" name="AirlinePref"/>
 *     &lt;xs:element type="ns:HotelPrefType" name="HotelPref"/>
 *     &lt;xs:element type="ns:VehicleRentalPrefType" name="VehicleRentalPref"/>
 *     &lt;xs:element type="ns:RailPrefType" name="RailPref"/>
 *     &lt;xs:element type="ns:GroundTransportationPrefType" name="GroundTransportationPref"/>
 *     &lt;xs:element type="ns:NotificationPreferenceType" name="NotificationPreference"/>
 *     &lt;xs:element type="ns:ConsentType" name="Consent"/>
 *     &lt;xs:element type="ns:PsychographicCategoryType" name="PsychographicCategory"/>
 *     &lt;xs:element type="ns:DeclaredTravelHistoryPreferenceType" name="DeclaredTravelHistoryPreference"/>
 *     &lt;xs:element type="ns:CustomDefinedValuesType" name="CustomDefinedValues"/>
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="ns:HistoryElementActionEnumType" use="required" name="Action"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HistoryCorporationSubjectAreaType implements Serializable
{
    private int choiceSelect = -1;
    private static final int TPA_IDENTITY_CHOICE = 0;
    private static final int CORPORATE_INFO_CHOICE = 1;
    private static final int CONTACT_NAME_CHOICE = 2;
    private static final int ADDRESS_CHOICE = 3;
    private static final int TELEPHONE_CHOICE = 4;
    private static final int EMAIL_CHOICE = 5;
    private static final int PAYMENT_FORM_CHOICE = 6;
    private static final int EMERGENCY_CONTACT_PERSON_CHOICE = 7;
    private static final int PRIORITY_REMARKS_CHOICE = 8;
    private static final int REMARK_CHOICE = 9;
    private static final int GDS_CHOICE = 10;
    private static final int CUSTOMER_REFERENCE_INFO_CHOICE = 11;
    private static final int SSR_CHOICE = 12;
    private static final int OSI_CHOICE = 13;
    private static final int BUSINESS_SYSTEM_IDENTITY_INFO_CHOICE = 14;
    private static final int ASSOCIATED_PROFILES_CHOICE = 15;
    private static final int ASSOCIATED_FILTERS_CHOICE = 16;
    private static final int ASSOCIATED_TEMPLATE_CHOICE = 17;
    private static final int ASSOCIATED_FORMATS_CHOICE = 18;
    private static final int DISCOUNTS_CHOICE = 19;
    private static final int CUSTOM_DEFINED_DATA_CHOICE = 20;
    private static final int TRAVEL_POLICY_CHOICE = 21;
    private static final int BRANDING_CHOICE = 22;
    private static final int STAR_DATA_CHOICE = 23;
    private static final int BUSINESS_TRAVELER_SETTING_CHOICE = 24;
    private static final int EMPLOYMENT_INFO_CHOICE = 25;
    private static final int AIRLINE_PREF_CHOICE = 26;
    private static final int HOTEL_PREF_CHOICE = 27;
    private static final int VEHICLE_RENTAL_PREF_CHOICE = 28;
    private static final int RAIL_PREF_CHOICE = 29;
    private static final int GROUND_TRANSPORTATION_PREF_CHOICE = 30;
    private static final int NOTIFICATION_PREFERENCE_CHOICE = 31;
    private static final int CONSENT_CHOICE = 32;
    private static final int PSYCHOGRAPHIC_CATEGORY_CHOICE = 33;
    private static final int DECLARED_TRAVEL_HISTORY_PREFERENCE_CHOICE = 34;
    private static final int CUSTOM_DEFINED_VALUES_CHOICE = 35;
    private TPAIdentityType TPAIdentity;
    private CorporateInfoType corporateInfo;
    private ContactNameType contactName;
    private AddressType address;
    private TelephoneType telephone;
    private EmailType email;
    private PaymentFormType paymentForm;
    private ContactType emergencyContactPerson;
    private PriorityRemarksType priorityRemarks;
    private RemarkType remark;
    private GDSType GDS;
    private CustomerReferenceInfoType customerReferenceInfo;
    private SSRType SSR;
    private OSIType OSI;
    private BusinessSystemIdentityInfoType businessSystemIdentityInfo;
    private AssociatedProfilesType associatedProfiles;
    private AssociatedFiltersType associatedFilters;
    private AssociatedTemplateType associatedTemplate;
    private AssociatedFormatsType associatedFormats;
    private DiscountsType discounts;
    private CustomDefinedDataType customDefinedData;
    private TravelPolicyType travelPolicy;
    private BrandingType branding;
    private STARDataType STARData;
    private BusinessTravelerSettingType businessTravelerSetting;
    private EmploymentInfoType employmentInfo;
    private AirlinePrefType airlinePref;
    private HotelPrefType hotelPref;
    private VehicleRentalPrefType vehicleRentalPref;
    private RailPrefType railPref;
    private GroundTransportationPrefType groundTransportationPref;
    private NotificationPreferenceType notificationPreference;
    private ConsentType consent;
    private PsychographicCategoryType psychographicCategory;
    private DeclaredTravelHistoryPreferenceType declaredTravelHistoryPreference;
    private CustomDefinedValuesType customDefinedValues;
    private HistoryElementActionEnumType action;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if TPAIdentity is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTPAIdentity() {
        return choiceSelect == TPA_IDENTITY_CHOICE;
    }

    /** 
     * Get the 'TPA_Identity' element value. TPA_Identity SubjectArea
     * 
     * @return value
     */
    public TPAIdentityType getTPAIdentity() {
        return TPAIdentity;
    }

    /** 
     * Set the 'TPA_Identity' element value. TPA_Identity SubjectArea
     * 
     * @param TPAIdentity
     */
    public void setTPAIdentity(TPAIdentityType TPAIdentity) {
        setChoiceSelect(TPA_IDENTITY_CHOICE);
        this.TPAIdentity = TPAIdentity;
    }

    /** 
     * Check if CorporateInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCorporateInfo() {
        return choiceSelect == CORPORATE_INFO_CHOICE;
    }

    /** 
     * Get the 'CorporateInfo' element value. ***SABRE ADDED*** Corporation information
     * 
     * @return value
     */
    public CorporateInfoType getCorporateInfo() {
        return corporateInfo;
    }

    /** 
     * Set the 'CorporateInfo' element value. ***SABRE ADDED*** Corporation information
     * 
     * @param corporateInfo
     */
    public void setCorporateInfo(CorporateInfoType corporateInfo) {
        setChoiceSelect(CORPORATE_INFO_CHOICE);
        this.corporateInfo = corporateInfo;
    }

    /** 
     * Check if ContactName is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifContactName() {
        return choiceSelect == CONTACT_NAME_CHOICE;
    }

    /** 
     * Get the 'ContactName' element value. *** SABRE ADDED *** Corporation Contact Name data 
     * 
     * @return value
     */
    public ContactNameType getContactName() {
        return contactName;
    }

    /** 
     * Set the 'ContactName' element value. *** SABRE ADDED *** Corporation Contact Name data 
     * 
     * @param contactName
     */
    public void setContactName(ContactNameType contactName) {
        setChoiceSelect(CONTACT_NAME_CHOICE);
        this.contactName = contactName;
    }

    /** 
     * Check if Address is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAddress() {
        return choiceSelect == ADDRESS_CHOICE;
    }

    /** 
     * Get the 'Address' element value. *** SABRE ADDED *** Corporation Address data 
     * 
     * @return value
     */
    public AddressType getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value. *** SABRE ADDED *** Corporation Address data 
     * 
     * @param address
     */
    public void setAddress(AddressType address) {
        setChoiceSelect(ADDRESS_CHOICE);
        this.address = address;
    }

    /** 
     * Check if Telephone is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTelephone() {
        return choiceSelect == TELEPHONE_CHOICE;
    }

    /** 
     * Get the 'Telephone' element value. *** SABRE ADDED *** Corporation Phone data 
     * 
     * @return value
     */
    public TelephoneType getTelephone() {
        return telephone;
    }

    /** 
     * Set the 'Telephone' element value. *** SABRE ADDED *** Corporation Phone data 
     * 
     * @param telephone
     */
    public void setTelephone(TelephoneType telephone) {
        setChoiceSelect(TELEPHONE_CHOICE);
        this.telephone = telephone;
    }

    /** 
     * Check if Email is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEmail() {
        return choiceSelect == EMAIL_CHOICE;
    }

    /** 
     * Get the 'Email' element value. *** SABRE ADDED *** Corporation Email data 
     * 
     * @return value
     */
    public EmailType getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value. *** SABRE ADDED *** Corporation Email data 
     * 
     * @param email
     */
    public void setEmail(EmailType email) {
        setChoiceSelect(EMAIL_CHOICE);
        this.email = email;
    }

    /** 
     * Check if PaymentForm is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPaymentForm() {
        return choiceSelect == PAYMENT_FORM_CHOICE;
    }

    /** 
     * Get the 'PaymentForm' element value. *** SABRE ADDED*** Payment Information 
     * 
     * @return value
     */
    public PaymentFormType getPaymentForm() {
        return paymentForm;
    }

    /** 
     * Set the 'PaymentForm' element value. *** SABRE ADDED*** Payment Information 
     * 
     * @param paymentForm
     */
    public void setPaymentForm(PaymentFormType paymentForm) {
        setChoiceSelect(PAYMENT_FORM_CHOICE);
        this.paymentForm = paymentForm;
    }

    /** 
     * Check if EmergencyContactPerson is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEmergencyContactPerson() {
        return choiceSelect == EMERGENCY_CONTACT_PERSON_CHOICE;
    }

    /** 
     * Get the 'EmergencyContactPerson' element value. ***OTA Based *** Emergency Contact Person Information 
     * 
     * @return value
     */
    public ContactType getEmergencyContactPerson() {
        return emergencyContactPerson;
    }

    /** 
     * Set the 'EmergencyContactPerson' element value. ***OTA Based *** Emergency Contact Person Information 
     * 
     * @param emergencyContactPerson
     */
    public void setEmergencyContactPerson(ContactType emergencyContactPerson) {
        setChoiceSelect(EMERGENCY_CONTACT_PERSON_CHOICE);
        this.emergencyContactPerson = emergencyContactPerson;
    }

    /** 
     * Check if PriorityRemarks is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPriorityRemarks() {
        return choiceSelect == PRIORITY_REMARKS_CHOICE;
    }

    /** 
     * Get the 'PriorityRemarks' element value. *** SABRE ADDED *** Priority Lines of a profile
     * 
     * @return value
     */
    public PriorityRemarksType getPriorityRemarks() {
        return priorityRemarks;
    }

    /** 
     * Set the 'PriorityRemarks' element value. *** SABRE ADDED *** Priority Lines of a profile
     * 
     * @param priorityRemarks
     */
    public void setPriorityRemarks(PriorityRemarksType priorityRemarks) {
        setChoiceSelect(PRIORITY_REMARKS_CHOICE);
        this.priorityRemarks = priorityRemarks;
    }

    /** 
     * Check if Remark is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRemark() {
        return choiceSelect == REMARK_CHOICE;
    }

    /** 
     * Get the 'Remark' element value. *** SABRE ADDED *** Remarks of a profile
     * 
     * @return value
     */
    public RemarkType getRemark() {
        return remark;
    }

    /** 
     * Set the 'Remark' element value. *** SABRE ADDED *** Remarks of a profile
     * 
     * @param remark
     */
    public void setRemark(RemarkType remark) {
        setChoiceSelect(REMARK_CHOICE);
        this.remark = remark;
    }

    /** 
     * Check if GDS is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGDS() {
        return choiceSelect == GDS_CHOICE;
    }

    /** 
     * Get the 'GDS' element value. ***SABRE ADDED*** GDS Information associated with an Corporation
     * 
     * @return value
     */
    public GDSType getGDS() {
        return GDS;
    }

    /** 
     * Set the 'GDS' element value. ***SABRE ADDED*** GDS Information associated with an Corporation
     * 
     * @param GDS
     */
    public void setGDS(GDSType GDS) {
        setChoiceSelect(GDS_CHOICE);
        this.GDS = GDS;
    }

    /** 
     * Check if CustomerReferenceInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomerReferenceInfo() {
        return choiceSelect == CUSTOMER_REFERENCE_INFO_CHOICE;
    }

    /** 
     * Get the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return value
     */
    public CustomerReferenceInfoType getCustomerReferenceInfo() {
        return customerReferenceInfo;
    }

    /** 
     * Set the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param customerReferenceInfo
     */
    public void setCustomerReferenceInfo(
            CustomerReferenceInfoType customerReferenceInfo) {
        setChoiceSelect(CUSTOMER_REFERENCE_INFO_CHOICE);
        this.customerReferenceInfo = customerReferenceInfo;
    }

    /** 
     * Check if SSR is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSSR() {
        return choiceSelect == SSR_CHOICE;
    }

    /** 
     * Get the 'SSR' element value. *** SABRE ADDED *** Special service requets for a profile
     * 
     * @return value
     */
    public SSRType getSSR() {
        return SSR;
    }

    /** 
     * Set the 'SSR' element value. *** SABRE ADDED *** Special service requets for a profile
     * 
     * @param SSR
     */
    public void setSSR(SSRType SSR) {
        setChoiceSelect(SSR_CHOICE);
        this.SSR = SSR;
    }

    /** 
     * Check if OSI is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOSI() {
        return choiceSelect == OSI_CHOICE;
    }

    /** 
     * Get the 'OSI' element value. *** SABRE ADDED *** Other Service Info for a profile
     * 
     * @return value
     */
    public OSIType getOSI() {
        return OSI;
    }

    /** 
     * Set the 'OSI' element value. *** SABRE ADDED *** Other Service Info for a profile
     * 
     * @param OSI
     */
    public void setOSI(OSIType OSI) {
        setChoiceSelect(OSI_CHOICE);
        this.OSI = OSI;
    }

    /** 
     * Check if BusinessSystemIdentityInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifBusinessSystemIdentityInfo() {
        return choiceSelect == BUSINESS_SYSTEM_IDENTITY_INFO_CHOICE;
    }

    /** 
     * Get the 'BusinessSystemIdentityInfo' element value. *** SABRE ADDED *** Corporation BackOffice System Information data 
     * 
     * @return value
     */
    public BusinessSystemIdentityInfoType getBusinessSystemIdentityInfo() {
        return businessSystemIdentityInfo;
    }

    /** 
     * Set the 'BusinessSystemIdentityInfo' element value. *** SABRE ADDED *** Corporation BackOffice System Information data 
     * 
     * @param businessSystemIdentityInfo
     */
    public void setBusinessSystemIdentityInfo(
            BusinessSystemIdentityInfoType businessSystemIdentityInfo) {
        setChoiceSelect(BUSINESS_SYSTEM_IDENTITY_INFO_CHOICE);
        this.businessSystemIdentityInfo = businessSystemIdentityInfo;
    }

    /** 
     * Check if AssociatedProfiles is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociatedProfiles() {
        return choiceSelect == ASSOCIATED_PROFILES_CHOICE;
    }

    /** 
     * Get the 'AssociatedProfiles' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Associated profiles
     * 
     * @return value
     */
    public AssociatedProfilesType getAssociatedProfiles() {
        return associatedProfiles;
    }

    /** 
     * Set the 'AssociatedProfiles' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Associated profiles
     * 
     * @param associatedProfiles
     */
    public void setAssociatedProfiles(AssociatedProfilesType associatedProfiles) {
        setChoiceSelect(ASSOCIATED_PROFILES_CHOICE);
        this.associatedProfiles = associatedProfiles;
    }

    /** 
     * Check if AssociatedFilters is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociatedFilters() {
        return choiceSelect == ASSOCIATED_FILTERS_CHOICE;
    }

    /** 
     * Get the 'AssociatedFilters' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area)  Filters Associated to a  profile
     * 
     * @return value
     */
    public AssociatedFiltersType getAssociatedFilters() {
        return associatedFilters;
    }

    /** 
     * Set the 'AssociatedFilters' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area)  Filters Associated to a  profile
     * 
     * @param associatedFilters
     */
    public void setAssociatedFilters(AssociatedFiltersType associatedFilters) {
        setChoiceSelect(ASSOCIATED_FILTERS_CHOICE);
        this.associatedFilters = associatedFilters;
    }

    /** 
     * Check if AssociatedTemplate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociatedTemplate() {
        return choiceSelect == ASSOCIATED_TEMPLATE_CHOICE;
    }

    /** 
     * Get the 'AssociatedTemplate' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Template Associated to a  profile
     * 
     * @return value
     */
    public AssociatedTemplateType getAssociatedTemplate() {
        return associatedTemplate;
    }

    /** 
     * Set the 'AssociatedTemplate' element value. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Template Associated to a  profile
     * 
     * @param associatedTemplate
     */
    public void setAssociatedTemplate(AssociatedTemplateType associatedTemplate) {
        setChoiceSelect(ASSOCIATED_TEMPLATE_CHOICE);
        this.associatedTemplate = associatedTemplate;
    }

    /** 
     * Check if AssociatedFormats is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociatedFormats() {
        return choiceSelect == ASSOCIATED_FORMATS_CHOICE;
    }

    /** 
     * Get the 'AssociatedFormats' element value. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @return value
     */
    public AssociatedFormatsType getAssociatedFormats() {
        return associatedFormats;
    }

    /** 
     * Set the 'AssociatedFormats' element value. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @param associatedFormats
     */
    public void setAssociatedFormats(AssociatedFormatsType associatedFormats) {
        setChoiceSelect(ASSOCIATED_FORMATS_CHOICE);
        this.associatedFormats = associatedFormats;
    }

    /** 
     * Check if Discounts is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDiscounts() {
        return choiceSelect == DISCOUNTS_CHOICE;
    }

    /** 
     * Get the 'Discounts' element value. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @return value
     */
    public DiscountsType getDiscounts() {
        return discounts;
    }

    /** 
     * Set the 'Discounts' element value. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @param discounts
     */
    public void setDiscounts(DiscountsType discounts) {
        setChoiceSelect(DISCOUNTS_CHOICE);
        this.discounts = discounts;
    }

    /** 
     * Check if CustomDefinedData is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomDefinedData() {
        return choiceSelect == CUSTOM_DEFINED_DATA_CHOICE;
    }

    /** 
     * Get the 'CustomDefinedData' element value. *** SABRE ADDED *** Customer Defined Data
     * 
     * @return value
     */
    public CustomDefinedDataType getCustomDefinedData() {
        return customDefinedData;
    }

    /** 
     * Set the 'CustomDefinedData' element value. *** SABRE ADDED *** Customer Defined Data
     * 
     * @param customDefinedData
     */
    public void setCustomDefinedData(CustomDefinedDataType customDefinedData) {
        setChoiceSelect(CUSTOM_DEFINED_DATA_CHOICE);
        this.customDefinedData = customDefinedData;
    }

    /** 
     * Check if TravelPolicy is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTravelPolicy() {
        return choiceSelect == TRAVEL_POLICY_CHOICE;
    }

    /** 
     * Get the 'TravelPolicy' element value. *** SABRE ADDED *** Travel Policy Information 
     * 
     * @return value
     */
    public TravelPolicyType getTravelPolicy() {
        return travelPolicy;
    }

    /** 
     * Set the 'TravelPolicy' element value. *** SABRE ADDED *** Travel Policy Information 
     * 
     * @param travelPolicy
     */
    public void setTravelPolicy(TravelPolicyType travelPolicy) {
        setChoiceSelect(TRAVEL_POLICY_CHOICE);
        this.travelPolicy = travelPolicy;
    }

    /** 
     * Check if Branding is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifBranding() {
        return choiceSelect == BRANDING_CHOICE;
    }

    /** 
     * Get the 'Branding' element value. ***SABRE ADDED *** Branding Informaion
     * 
     * @return value
     */
    public BrandingType getBranding() {
        return branding;
    }

    /** 
     * Set the 'Branding' element value. ***SABRE ADDED *** Branding Informaion
     * 
     * @param branding
     */
    public void setBranding(BrandingType branding) {
        setChoiceSelect(BRANDING_CHOICE);
        this.branding = branding;
    }

    /** 
     * Check if STARData is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSTARData() {
        return choiceSelect == STAR_DATA_CHOICE;
    }

    /** 
     * Get the 'STARData' element value. *** SABRE ADDED *** STAR Data that got migrated to PPP *** Please Note that this is Temporary only and will not be supported in PPP after 2012
     * 
     * @return value
     */
    public STARDataType getSTARData() {
        return STARData;
    }

    /** 
     * Set the 'STARData' element value. *** SABRE ADDED *** STAR Data that got migrated to PPP *** Please Note that this is Temporary only and will not be supported in PPP after 2012
     * 
     * @param STARData
     */
    public void setSTARData(STARDataType STARData) {
        setChoiceSelect(STAR_DATA_CHOICE);
        this.STARData = STARData;
    }

    /** 
     * Check if BusinessTravelerSetting is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifBusinessTravelerSetting() {
        return choiceSelect == BUSINESS_TRAVELER_SETTING_CHOICE;
    }

    /** 
     * Get the 'BusinessTravelerSetting' element value. ***SABRE ADDED*** Business Traveler Settings associated to a corporation
     * 
     * @return value
     */
    public BusinessTravelerSettingType getBusinessTravelerSetting() {
        return businessTravelerSetting;
    }

    /** 
     * Set the 'BusinessTravelerSetting' element value. ***SABRE ADDED*** Business Traveler Settings associated to a corporation
     * 
     * @param businessTravelerSetting
     */
    public void setBusinessTravelerSetting(
            BusinessTravelerSettingType businessTravelerSetting) {
        setChoiceSelect(BUSINESS_TRAVELER_SETTING_CHOICE);
        this.businessTravelerSetting = businessTravelerSetting;
    }

    /** 
     * Check if EmploymentInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEmploymentInfo() {
        return choiceSelect == EMPLOYMENT_INFO_CHOICE;
    }

    /** 
     * Get the 'EmploymentInfo' element value. *** Sabre Added *** EmploymentInfo elements and attributes, per Trading Partner Agreement (TPA)							
     * 
     * @return value
     */
    public EmploymentInfoType getEmploymentInfo() {
        return employmentInfo;
    }

    /** 
     * Set the 'EmploymentInfo' element value. *** Sabre Added *** EmploymentInfo elements and attributes, per Trading Partner Agreement (TPA)							
     * 
     * @param employmentInfo
     */
    public void setEmploymentInfo(EmploymentInfoType employmentInfo) {
        setChoiceSelect(EMPLOYMENT_INFO_CHOICE);
        this.employmentInfo = employmentInfo;
    }

    /** 
     * Check if AirlinePref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirlinePref() {
        return choiceSelect == AIRLINE_PREF_CHOICE;
    }

    /** 
     * Get the 'AirlinePref' element value. ***OTA Based *** Airline Preference Information 
     * 
     * @return value
     */
    public AirlinePrefType getAirlinePref() {
        return airlinePref;
    }

    /** 
     * Set the 'AirlinePref' element value. ***OTA Based *** Airline Preference Information 
     * 
     * @param airlinePref
     */
    public void setAirlinePref(AirlinePrefType airlinePref) {
        setChoiceSelect(AIRLINE_PREF_CHOICE);
        this.airlinePref = airlinePref;
    }

    /** 
     * Check if HotelPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifHotelPref() {
        return choiceSelect == HOTEL_PREF_CHOICE;
    }

    /** 
     * Get the 'HotelPref' element value. ***OTA Based *** Hotel Preference Information 
     * 
     * @return value
     */
    public HotelPrefType getHotelPref() {
        return hotelPref;
    }

    /** 
     * Set the 'HotelPref' element value. ***OTA Based *** Hotel Preference Information 
     * 
     * @param hotelPref
     */
    public void setHotelPref(HotelPrefType hotelPref) {
        setChoiceSelect(HOTEL_PREF_CHOICE);
        this.hotelPref = hotelPref;
    }

    /** 
     * Check if VehicleRentalPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifVehicleRentalPref() {
        return choiceSelect == VEHICLE_RENTAL_PREF_CHOICE;
    }

    /** 
     * Get the 'VehicleRentalPref' element value. ***OTA Based *** Vehicle Preference Information 
     * 
     * @return value
     */
    public VehicleRentalPrefType getVehicleRentalPref() {
        return vehicleRentalPref;
    }

    /** 
     * Set the 'VehicleRentalPref' element value. ***OTA Based *** Vehicle Preference Information 
     * 
     * @param vehicleRentalPref
     */
    public void setVehicleRentalPref(VehicleRentalPrefType vehicleRentalPref) {
        setChoiceSelect(VEHICLE_RENTAL_PREF_CHOICE);
        this.vehicleRentalPref = vehicleRentalPref;
    }

    /** 
     * Check if RailPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRailPref() {
        return choiceSelect == RAIL_PREF_CHOICE;
    }

    /** 
     * Get the 'RailPref' element value. ***SABRE ADDED *** Rail Preference Information 
     * 
     * @return value
     */
    public RailPrefType getRailPref() {
        return railPref;
    }

    /** 
     * Set the 'RailPref' element value. ***SABRE ADDED *** Rail Preference Information 
     * 
     * @param railPref
     */
    public void setRailPref(RailPrefType railPref) {
        setChoiceSelect(RAIL_PREF_CHOICE);
        this.railPref = railPref;
    }

    /** 
     * Check if GroundTransportationPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGroundTransportationPref() {
        return choiceSelect == GROUND_TRANSPORTATION_PREF_CHOICE;
    }

    /** 
     * Get the 'GroundTransportationPref' element value. ***SABRE ADDED *** Ground Transportation Preference Information 
     * 
     * @return value
     */
    public GroundTransportationPrefType getGroundTransportationPref() {
        return groundTransportationPref;
    }

    /** 
     * Set the 'GroundTransportationPref' element value. ***SABRE ADDED *** Ground Transportation Preference Information 
     * 
     * @param groundTransportationPref
     */
    public void setGroundTransportationPref(
            GroundTransportationPrefType groundTransportationPref) {
        setChoiceSelect(GROUND_TRANSPORTATION_PREF_CHOICE);
        this.groundTransportationPref = groundTransportationPref;
    }

    /** 
     * Check if NotificationPreference is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifNotificationPreference() {
        return choiceSelect == NOTIFICATION_PREFERENCE_CHOICE;
    }

    /** 
     * Get the 'NotificationPreference' element value. *** SABRE ADDED *** Notification Prefereces for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @return value
     */
    public NotificationPreferenceType getNotificationPreference() {
        return notificationPreference;
    }

    /** 
     * Set the 'NotificationPreference' element value. *** SABRE ADDED *** Notification Prefereces for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @param notificationPreference
     */
    public void setNotificationPreference(
            NotificationPreferenceType notificationPreference) {
        setChoiceSelect(NOTIFICATION_PREFERENCE_CHOICE);
        this.notificationPreference = notificationPreference;
    }

    /** 
     * Check if Consent is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifConsent() {
        return choiceSelect == CONSENT_CHOICE;
    }

    /** 
     * Get the 'Consent' element value. *** SABRE ADDED *** Application Consents of a profile
     * 
     * @return value
     */
    public ConsentType getConsent() {
        return consent;
    }

    /** 
     * Set the 'Consent' element value. *** SABRE ADDED *** Application Consents of a profile
     * 
     * @param consent
     */
    public void setConsent(ConsentType consent) {
        setChoiceSelect(CONSENT_CHOICE);
        this.consent = consent;
    }

    /** 
     * Check if PsychographicCategory is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPsychographicCategory() {
        return choiceSelect == PSYCHOGRAPHIC_CATEGORY_CHOICE;
    }

    /** 
     * Get the 'PsychographicCategory' element value. *** SABRE ADDED *** Stated Interests for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @return value
     */
    public PsychographicCategoryType getPsychographicCategory() {
        return psychographicCategory;
    }

    /** 
     * Set the 'PsychographicCategory' element value. *** SABRE ADDED *** Stated Interests for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @param psychographicCategory
     */
    public void setPsychographicCategory(
            PsychographicCategoryType psychographicCategory) {
        setChoiceSelect(PSYCHOGRAPHIC_CATEGORY_CHOICE);
        this.psychographicCategory = psychographicCategory;
    }

    /** 
     * Check if DeclaredTravelHistoryPreference is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDeclaredTravelHistoryPreference() {
        return choiceSelect == DECLARED_TRAVEL_HISTORY_PREFERENCE_CHOICE;
    }

    /** 
     * Get the 'DeclaredTravelHistoryPreference' element value.
     * 
     * @return value
     */
    public DeclaredTravelHistoryPreferenceType getDeclaredTravelHistoryPreference() {
        return declaredTravelHistoryPreference;
    }

    /** 
     * Set the 'DeclaredTravelHistoryPreference' element value.
     * 
     * @param declaredTravelHistoryPreference
     */
    public void setDeclaredTravelHistoryPreference(
            DeclaredTravelHistoryPreferenceType declaredTravelHistoryPreference) {
        setChoiceSelect(DECLARED_TRAVEL_HISTORY_PREFERENCE_CHOICE);
        this.declaredTravelHistoryPreference = declaredTravelHistoryPreference;
    }

    /** 
     * Check if CustomDefinedValues is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomDefinedValues() {
        return choiceSelect == CUSTOM_DEFINED_VALUES_CHOICE;
    }

    /** 
     * Get the 'CustomDefinedValues' element value.
     * 
     * @return value
     */
    public CustomDefinedValuesType getCustomDefinedValues() {
        return customDefinedValues;
    }

    /** 
     * Set the 'CustomDefinedValues' element value.
     * 
     * @param customDefinedValues
     */
    public void setCustomDefinedValues(
            CustomDefinedValuesType customDefinedValues) {
        setChoiceSelect(CUSTOM_DEFINED_VALUES_CHOICE);
        this.customDefinedValues = customDefinedValues;
    }

    /** 
     * Get the 'Action' attribute value. Add - Subject Area is Added
    Delete - Subject Area is Deleted
     * 
     * @return value
     */
    public HistoryElementActionEnumType getAction() {
        return action;
    }

    /** 
     * Set the 'Action' attribute value. Add - Subject Area is Added
    Delete - Subject Area is Deleted
     * 
     * @param action
     */
    public void setAction(HistoryElementActionEnumType action) {
        this.action = action;
    }
}
