
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 *  *** SABRE ADDED *** Enumeration with availible history actions for whole profile
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HistoryProfileActionEnumType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Update"/>
 *     &lt;xs:enumeration value="Delete"/>
 *     &lt;xs:enumeration value="Restore"/>
 *     &lt;xs:enumeration value="Create"/>
 *     &lt;xs:enumeration value="Move"/>
 *     &lt;xs:enumeration value="Copy"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum HistoryProfileActionEnumType implements Serializable {
    UPDATE("Update"), DELETE("Delete"), RESTORE("Restore"), CREATE("Create"), MOVE(
            "Move"), COPY("Copy");
    private final String value;

    private HistoryProfileActionEnumType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static HistoryProfileActionEnumType convert(String value) {
        for (HistoryProfileActionEnumType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
