
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 *  
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HistoryProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:HistoryTPA_IdentityType" name="TPA_Identity"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HistoryProfileType implements Serializable
{
    private HistoryTPAIdentityType TPAIdentity;
    private Choice choice;

    /** 
     * Get the 'TPA_Identity' element value.
     * 
     * @return value
     */
    public HistoryTPAIdentityType getTPAIdentity() {
        return TPAIdentity;
    }

    /** 
     * Set the 'TPA_Identity' element value.
     * 
     * @param TPAIdentity
     */
    public void setTPAIdentity(HistoryTPAIdentityType TPAIdentity) {
        this.TPAIdentity = TPAIdentity;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:HistoryTravelerProfileType" name="Traveler"/>
     *   &lt;xs:element type="ns:HistoryOperationalProfileType" name="OperationalProfile"/>
     *   &lt;xs:element type="ns:HistoryCorporationProfileType" name="Corporation"/>
     *   &lt;xs:element type="ns:HistoryTravelAgencyProfileType" name="TravelAgency"/>
     *   &lt;xs:element type="ns:HistoryTravelAgentProfileType" name="TravelAgent"/>
     *   &lt;xs:element type="ns:HistoryGroupProfileType" name="GroupProfile"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int TRAVELER_CHOICE = 0;
        private static final int OPERATIONAL_PROFILE_CHOICE = 1;
        private static final int CORPORATION_CHOICE = 2;
        private static final int TRAVEL_AGENCY_CHOICE = 3;
        private static final int TRAVEL_AGENT_CHOICE = 4;
        private static final int GROUP_PROFILE_CHOICE = 5;
        private HistoryTravelerProfileType traveler;
        private HistoryOperationalProfileType operationalProfile;
        private HistoryCorporationProfileType corporation;
        private HistoryTravelAgencyProfileType travelAgency;
        private HistoryTravelAgentProfileType travelAgent;
        private HistoryGroupProfileType groupProfile;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Traveler is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTraveler() {
            return choiceSelect == TRAVELER_CHOICE;
        }

        /** 
         * Get the 'Traveler' element value.
         * 
         * @return value
         */
        public HistoryTravelerProfileType getTraveler() {
            return traveler;
        }

        /** 
         * Set the 'Traveler' element value.
         * 
         * @param traveler
         */
        public void setTraveler(HistoryTravelerProfileType traveler) {
            setChoiceSelect(TRAVELER_CHOICE);
            this.traveler = traveler;
        }

        /** 
         * Check if OperationalProfile is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOperationalProfile() {
            return choiceSelect == OPERATIONAL_PROFILE_CHOICE;
        }

        /** 
         * Get the 'OperationalProfile' element value.
         * 
         * @return value
         */
        public HistoryOperationalProfileType getOperationalProfile() {
            return operationalProfile;
        }

        /** 
         * Set the 'OperationalProfile' element value.
         * 
         * @param operationalProfile
         */
        public void setOperationalProfile(
                HistoryOperationalProfileType operationalProfile) {
            setChoiceSelect(OPERATIONAL_PROFILE_CHOICE);
            this.operationalProfile = operationalProfile;
        }

        /** 
         * Check if Corporation is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCorporation() {
            return choiceSelect == CORPORATION_CHOICE;
        }

        /** 
         * Get the 'Corporation' element value.
         * 
         * @return value
         */
        public HistoryCorporationProfileType getCorporation() {
            return corporation;
        }

        /** 
         * Set the 'Corporation' element value.
         * 
         * @param corporation
         */
        public void setCorporation(HistoryCorporationProfileType corporation) {
            setChoiceSelect(CORPORATION_CHOICE);
            this.corporation = corporation;
        }

        /** 
         * Check if TravelAgency is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTravelAgency() {
            return choiceSelect == TRAVEL_AGENCY_CHOICE;
        }

        /** 
         * Get the 'TravelAgency' element value.
         * 
         * @return value
         */
        public HistoryTravelAgencyProfileType getTravelAgency() {
            return travelAgency;
        }

        /** 
         * Set the 'TravelAgency' element value.
         * 
         * @param travelAgency
         */
        public void setTravelAgency(HistoryTravelAgencyProfileType travelAgency) {
            setChoiceSelect(TRAVEL_AGENCY_CHOICE);
            this.travelAgency = travelAgency;
        }

        /** 
         * Check if TravelAgent is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTravelAgent() {
            return choiceSelect == TRAVEL_AGENT_CHOICE;
        }

        /** 
         * Get the 'TravelAgent' element value.
         * 
         * @return value
         */
        public HistoryTravelAgentProfileType getTravelAgent() {
            return travelAgent;
        }

        /** 
         * Set the 'TravelAgent' element value.
         * 
         * @param travelAgent
         */
        public void setTravelAgent(HistoryTravelAgentProfileType travelAgent) {
            setChoiceSelect(TRAVEL_AGENT_CHOICE);
            this.travelAgent = travelAgent;
        }

        /** 
         * Check if GroupProfile is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifGroupProfile() {
            return choiceSelect == GROUP_PROFILE_CHOICE;
        }

        /** 
         * Get the 'GroupProfile' element value.
         * 
         * @return value
         */
        public HistoryGroupProfileType getGroupProfile() {
            return groupProfile;
        }

        /** 
         * Set the 'GroupProfile' element value.
         * 
         * @param groupProfile
         */
        public void setGroupProfile(HistoryGroupProfileType groupProfile) {
            setChoiceSelect(GROUP_PROFILE_CHOICE);
            this.groupProfile = groupProfile;
        }
    }
}
