
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LoginType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:SecurityInfoType" name="SecurityInfo" minOccurs="0" maxOccurs="10"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="LoginID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PasswordHash"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="PasswordExpired"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SiteName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SubSiteName"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="Y" name="IsHashed"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LoginType implements Serializable
{
    private List<SecurityInfoType> securityInfoList = new ArrayList<SecurityInfoType>();
    private String loginID;
    private String passwordHash;
    private YesNoType passwordExpired;
    private String siteName;
    private String subSiteName;
    private YesNoType isHashed;

    /** 
     * Get the list of 'SecurityInfo' element items. ** SABRE ADDED ** Security Information associated with a Login 
     * 
     * @return list
     */
    public List<SecurityInfoType> getSecurityInfoList() {
        return securityInfoList;
    }

    /** 
     * Set the list of 'SecurityInfo' element items. ** SABRE ADDED ** Security Information associated with a Login 
     * 
     * @param list
     */
    public void setSecurityInfoList(List<SecurityInfoType> list) {
        securityInfoList = list;
    }

    /** 
     * Get the 'LoginID' attribute value.
     * 
     * @return value
     */
    public String getLoginID() {
        return loginID;
    }

    /** 
     * Set the 'LoginID' attribute value.
     * 
     * @param loginID
     */
    public void setLoginID(String loginID) {
        this.loginID = loginID;
    }

    /** 
     * Get the 'PasswordHash' attribute value.
     * 
     * @return value
     */
    public String getPasswordHash() {
        return passwordHash;
    }

    /** 
     * Set the 'PasswordHash' attribute value.
     * 
     * @param passwordHash
     */
    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    /** 
     * Get the 'PasswordExpired' attribute value.
     * 
     * @return value
     */
    public YesNoType getPasswordExpired() {
        return passwordExpired;
    }

    /** 
     * Set the 'PasswordExpired' attribute value.
     * 
     * @param passwordExpired
     */
    public void setPasswordExpired(YesNoType passwordExpired) {
        this.passwordExpired = passwordExpired;
    }

    /** 
     * Get the 'SiteName' attribute value. Sitename for which the login ID will be associated ( Site can be a website , POS etc , or Site in GT that the profile is setup during customer implementation
     * 
     * @return value
     */
    public String getSiteName() {
        return siteName;
    }

    /** 
     * Set the 'SiteName' attribute value. Sitename for which the login ID will be associated ( Site can be a website , POS etc , or Site in GT that the profile is setup during customer implementation
     * 
     * @param siteName
     */
    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    /** 
     * Get the 'SubSiteName' attribute value. Subsite of the Sitename for which the login ID will be associated ( SubSite can be a website , POS etc , or subsite of the site in GT that the profile is setup during customer implementation
     * 
     * @return value
     */
    public String getSubSiteName() {
        return subSiteName;
    }

    /** 
     * Set the 'SubSiteName' attribute value. Subsite of the Sitename for which the login ID will be associated ( SubSite can be a website , POS etc , or subsite of the site in GT that the profile is setup during customer implementation
     * 
     * @param subSiteName
     */
    public void setSubSiteName(String subSiteName) {
        this.subSiteName = subSiteName;
    }

    /** 
     * Get the 'IsHashed' attribute value.
     * 
     * @return value
     */
    public YesNoType getIsHashed() {
        return isHashed;
    }

    /** 
     * Set the 'IsHashed' attribute value.
     * 
     * @param isHashed
     */
    public void setIsHashed(YesNoType isHashed) {
        this.isHashed = isHashed;
    }
}
