
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MetaTagType">
 *   &lt;xs:attribute type="xs:string" use="required" name="XPath"/>
 *   &lt;xs:attribute type="ns:AccessibilityType" use="required" name="Accessibility"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DefaultValue"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="NmbrOfElements"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MetaTagType implements Serializable
{
    private String XPath;
    private AccessibilityType accessibility;
    private String defaultValue;
    private String nmbrOfElements;

    /** 
     * Get the 'XPath' attribute value. XPath expression for Profile element described in Metadata
     * 
     * @return value
     */
    public String getXPath() {
        return XPath;
    }

    /** 
     * Set the 'XPath' attribute value. XPath expression for Profile element described in Metadata
     * 
     * @param XPath
     */
    public void setXPath(String XPath) {
        this.XPath = XPath;
    }

    /** 
     * Get the 'Accessibility' attribute value. Access mode for Profile element described in Metadata: RW - Readable/Writeable, RO - Read Only, NA - Not Available
     * 
     * @return value
     */
    public AccessibilityType getAccessibility() {
        return accessibility;
    }

    /** 
     * Set the 'Accessibility' attribute value. Access mode for Profile element described in Metadata: RW - Readable/Writeable, RO - Read Only, NA - Not Available
     * 
     * @param accessibility
     */
    public void setAccessibility(AccessibilityType accessibility) {
        this.accessibility = accessibility;
    }

    /** 
     * Get the 'DefaultValue' attribute value. Default value for Profile element described in Metadata
     * 
     * @return value
     */
    public String getDefaultValue() {
        return defaultValue;
    }

    /** 
     * Set the 'DefaultValue' attribute value. Default value for Profile element described in Metadata
     * 
     * @param defaultValue
     */
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    /** 
     * Get the 'NmbrOfElements' attribute value. Number of Profile elements to be shown. E.g. number of Emails
     * 
     * @return value
     */
    public String getNmbrOfElements() {
        return nmbrOfElements;
    }

    /** 
     * Set the 'NmbrOfElements' attribute value. Number of Profile elements to be shown. E.g. number of Emails
     * 
     * @param nmbrOfElements
     */
    public void setNmbrOfElements(String nmbrOfElements) {
        this.nmbrOfElements = nmbrOfElements;
    }
}
