
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MetadataIdentityType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MetadataIDType">
 *       &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *       &lt;xs:attribute type="ns:ProfileTypeInfo" use="required" name="ProfileTypeCode"/>
 *       &lt;xs:attribute type="xs:string" name="MetadataName"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MetadataIdentityType extends MetadataIDType implements
    Serializable
{
    private String clientContextCode;
    private ProfileTypeInfo profileTypeCode;
    private String metadataName;

    /** 
     * Get the 'ClientContextCode' attribute value. ClientContextCode indicated calling applications ex: MYS, NTC
    					
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. ClientContextCode indicated calling applications ex: MYS, NTC
    					
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'ProfileTypeCode' attribute value. Profile Type code of Profile this Metadata binded to
     * 
     * @return value
     */
    public ProfileTypeInfo getProfileTypeCode() {
        return profileTypeCode;
    }

    /** 
     * Set the 'ProfileTypeCode' attribute value. Profile Type code of Profile this Metadata binded to
     * 
     * @param profileTypeCode
     */
    public void setProfileTypeCode(ProfileTypeInfo profileTypeCode) {
        this.profileTypeCode = profileTypeCode;
    }

    /** 
     * Get the 'MetadataName' attribute value. Name of the metadata
     * 
     * @return value
     */
    public String getMetadataName() {
        return metadataName;
    }

    /** 
     * Set the 'MetadataName' attribute value. Name of the metadata
     * 
     * @param metadataName
     */
    public void setMetadataName(String metadataName) {
        this.metadataName = metadataName;
    }
}
