
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * ***SABRE ADDED*** This is notification preference element
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NotificationPreferenceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LanguageID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PreferenceStartTime"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PreferenceEndTime"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="DaysPriorToStartNotification"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PreferredDeviceDeliveryCapabilityCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PurposeCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class NotificationPreferenceType implements Serializable
{
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String languageID;
    private String preferenceStartTime;
    private String preferenceEndTime;
    private BigInteger daysPriorToStartNotification;
    private String preferredDeviceDeliveryCapabilityCode;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String purposeCode;

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'LanguageID' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @return value
     */
    public String getLanguageID() {
        return languageID;
    }

    /** 
     * Set the 'LanguageID' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @param languageID
     */
    public void setLanguageID(String languageID) {
        this.languageID = languageID;
    }

    /** 
     * Get the 'PreferenceStartTime' attribute value.
     * 
     * @return value
     */
    public String getPreferenceStartTime() {
        return preferenceStartTime;
    }

    /** 
     * Set the 'PreferenceStartTime' attribute value.
     * 
     * @param preferenceStartTime
     */
    public void setPreferenceStartTime(String preferenceStartTime) {
        this.preferenceStartTime = preferenceStartTime;
    }

    /** 
     * Get the 'PreferenceEndTime' attribute value.
     * 
     * @return value
     */
    public String getPreferenceEndTime() {
        return preferenceEndTime;
    }

    /** 
     * Set the 'PreferenceEndTime' attribute value.
     * 
     * @param preferenceEndTime
     */
    public void setPreferenceEndTime(String preferenceEndTime) {
        this.preferenceEndTime = preferenceEndTime;
    }

    /** 
     * Get the 'DaysPriorToStartNotification' attribute value.
     * 
     * @return value
     */
    public BigInteger getDaysPriorToStartNotification() {
        return daysPriorToStartNotification;
    }

    /** 
     * Set the 'DaysPriorToStartNotification' attribute value.
     * 
     * @param daysPriorToStartNotification
     */
    public void setDaysPriorToStartNotification(
            BigInteger daysPriorToStartNotification) {
        this.daysPriorToStartNotification = daysPriorToStartNotification;
    }

    /** 
     * Get the 'PreferredDeviceDeliveryCapabilityCode' attribute value.
     * 
     * @return value
     */
    public String getPreferredDeviceDeliveryCapabilityCode() {
        return preferredDeviceDeliveryCapabilityCode;
    }

    /** 
     * Set the 'PreferredDeviceDeliveryCapabilityCode' attribute value.
     * 
     * @param preferredDeviceDeliveryCapabilityCode
     */
    public void setPreferredDeviceDeliveryCapabilityCode(
            String preferredDeviceDeliveryCapabilityCode) {
        this.preferredDeviceDeliveryCapabilityCode = preferredDeviceDeliveryCapabilityCode;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value.
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value.
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'PurposeCode' attribute value. Identifies the purpose of this preference, such as marketing, traveler care, or others
     * 
     * @return value
     */
    public String getPurposeCode() {
        return purposeCode;
    }

    /** 
     * Set the 'PurposeCode' attribute value. Identifies the purpose of this preference, such as marketing, traveler care, or others
     * 
     * @param purposeCode
     */
    public void setPurposeCode(String purposeCode) {
        this.purposeCode = purposeCode;
    }
}
