
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Other Service  Info Data
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OSIType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ServiceTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="TypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="Text"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="ns:VIT_StarLineType" use="optional" name="VIT_LineType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_SecondaryQualifier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_OrderNmbr"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OSIType implements Serializable
{
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String serviceTypeCode;
    private String typeCode;
    private String text;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private VITStarLineType VITLineType;
    private String VITSecondaryQualifier;
    private String VITOrderNmbr;
    private String informationText;

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'ServiceTypeCode' attribute value.
     * 
     * @return value
     */
    public String getServiceTypeCode() {
        return serviceTypeCode;
    }

    /** 
     * Set the 'ServiceTypeCode' attribute value.
     * 
     * @param serviceTypeCode
     */
    public void setServiceTypeCode(String serviceTypeCode) {
        this.serviceTypeCode = serviceTypeCode;
    }

    /** 
     * Get the 'TypeCode' attribute value.
     * 
     * @return value
     */
    public String getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' attribute value.
     * 
     * @param typeCode
     */
    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    /** 
     * Get the 'Text' attribute value.
     * 
     * @return value
     */
    public String getText() {
        return text;
    }

    /** 
     * Set the 'Text' attribute value.
     * 
     * @param text
     */
    public void setText(String text) {
        this.text = text;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'VIT_LineType' attribute value.
     * 
     * @return value
     */
    public VITStarLineType getVITLineType() {
        return VITLineType;
    }

    /** 
     * Set the 'VIT_LineType' attribute value.
     * 
     * @param VITLineType
     */
    public void setVITLineType(VITStarLineType VITLineType) {
        this.VITLineType = VITLineType;
    }

    /** 
     * Get the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @return value
     */
    public String getVITSecondaryQualifier() {
        return VITSecondaryQualifier;
    }

    /** 
     * Set the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @param VITSecondaryQualifier
     */
    public void setVITSecondaryQualifier(String VITSecondaryQualifier) {
        this.VITSecondaryQualifier = VITSecondaryQualifier;
    }

    /** 
     * Get the 'VIT_OrderNmbr' attribute value.
     * 
     * @return value
     */
    public String getVITOrderNmbr() {
        return VITOrderNmbr;
    }

    /** 
     * Set the 'VIT_OrderNmbr' attribute value.
     * 
     * @param VITOrderNmbr
     */
    public void setVITOrderNmbr(String VITOrderNmbr) {
        this.VITOrderNmbr = VITOrderNmbr;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a OSI
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a OSI
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }
}
