
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Identifes an action to take place.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PartialChildDataType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="/Profile/TPA_Identity/Login"/>
 *     &lt;xs:enumeration value="/Profile/TPA_Identity/ProfileSubType"/>
 *     &lt;xs:enumeration value="/Profile/TPA_Identity/SecurityInfo"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/Customer/Address"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/Customer/Document"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/Customer/CustLoyalty"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/Customer/Email"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/Customer/EmergencyContactPerson"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/Customer/EmploymentInfo"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/Customer/PaymentForm"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/Customer/PersonName"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/Customer/RelatedTraveler"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/Customer/Telephone"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/PrefCollections/AirlinePref/AirlineCabinPref"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/PrefCollections/AirlinePref/AirlineMealPref"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/PrefCollections/AirlinePref/AirlineSeatPref"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/PrefCollections/AirlinePref/AirlineUpgradePref"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/PrefCollections/AirlinePref/AirportPref"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/PrefCollections/AirlinePref/PreferredAggregator"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/PrefCollections/AirlinePref/PreferredAirlines"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/PrefCollections/HotelPref/PreferredAggregator"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/PrefCollections/HotelPref/PreferredHotel"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/PrefCollections/VehicleRentalPref/PreferredAggregator"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/PrefCollections/VehicleRentalPref/PreferredVehicleVendors"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/PrefCollections/TPA_MarketingPreference/NotificationPreference"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/PrefCollections/TPA_MarketingPreference/Consent"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/PrefCollections/TPA_MarketingPreference/PsychographicCategory"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/TPA_Extensions/PriorityRemarks"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/TPA_Extensions/Remark"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/TPA_Extensions/SSR"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/TPA_Extensions/OSI"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/TPA_Extensions/CustomerReferenceInfo"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/TPA_Extensions/AssociatedProfiles"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/TPA_Extensions/AssociatedFilters"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/TPA_Extensions/AssociatedTemplate"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/TPA_Extensions/Discounts"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/TPA_Extensions/CustomDefinedData"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/TPA_Extensions/CustomerValueScore"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/TPA_Extensions/TravelPolicy/SabreTravelPolicy/Policy"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/TPA_Extensions/TravelPolicy/SabreTravelPolicy/Preference"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/TravelPolicy/SabreTravelPolicy/Policy"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/TravelPolicy/SabreTravelPolicy/Preference"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/TravelPolicy/SabreTravelPolicy/Policy"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/TravelPolicy/SabreTravelPolicy/Preference"/>
 *     &lt;xs:enumeration value="/Profile/GroupProfile/TravelPolicy/SabreTravelPolicy/Policy"/>
 *     &lt;xs:enumeration value="/Profile/GroupProfile/TravelPolicy/SabreTravelPolicy/Preference"/>
 *     &lt;xs:enumeration value="/Profile/GroupProfile/PaymentForm"/>
 *     &lt;xs:enumeration value="/Profile/OperationalProfile/TravelPolicy/SabreTravelPolicy/Policy"/>
 *     &lt;xs:enumeration value="/Profile/OperationalProfile/TravelPolicy/SabreTravelPolicy/Preference"/>
 *     &lt;xs:enumeration value="/Profile/OperationalProfile/PaymentForm"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/AgencyContactName"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/AgencyInfo"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/Telephone"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/Email"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/Address"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/PaymentForm"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/EmergencyContactPerson"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/GDS"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/OtherSystemIdentityInfo"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/Branding"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/PriorityRemarks"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/Remark"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/CustomerReferenceInfo"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/AssociatedProfiles"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/AssociatedFilters"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/AssociatedTemplate"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/PrefCollections/AirlinePref/AirportOriginPref"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/PrefCollections/AirlinePref/AirlineSeatPref"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/PrefCollections/AirlinePref/AirlineMealPref"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/PrefCollections/HotelPref/HotelChainPref"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/PrefCollections/HotelPref/HotelMealPref"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/PrefCollections/VehicleRentalPref/VehicleVendorPref"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/PrefCollections/TPA_MarketingPreference/NotificationPreference"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/PrefCollections/TPA_MarketingPreference/Consent"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/PrefCollections/TPA_MarketingPreference/PsychographicCategory"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/Discounts"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgency/CustomDefinedData"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/CorporateInfo"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/ContactName"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/Telephone"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/Email"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/Address"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/PaymentForm"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/EmergencyContactPerson"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/SalesManager"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/PriorityRemarks"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/Remark"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/CustomerReferenceInfo"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/AssociatedProfiles"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/AssociatedFilters"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/AssociatedTemplate"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/PrefCollections/AirlinePref/AirportOriginPref"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/PrefCollections/AirlinePref/AirlineSeatPref"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/PrefCollections/AirlinePref/AirlineMealPref"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/PrefCollections/HotelPref/HotelChainPref"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/PrefCollections/HotelPref/HotelMealPref"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/PrefCollections/VehicleRentalPref/VehicleVendorPref"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/PrefCollections/TPA_MarketingPreference/NotificationPreference"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/PrefCollections/TPA_MarketingPreference/Consent"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/PrefCollections/TPA_MarketingPreference/PsychographicCategory"/>
 *     &lt;xs:enumeration value="/Profile/Traveler/PrefCollections/LoungePref"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/Discounts"/>
 *     &lt;xs:enumeration value="/Profile/Corporation/CustomDefinedData"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/AgentName"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/AgentInfo"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/OtherSystemIdentityInfo"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/Telephone"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/Email"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/Address"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/PaymentForm"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/AgentRelatedNames"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/EmergencyContactPerson"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/Document"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/CustLoyalty"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/EmploymentInfo"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/GDS"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/PriorityRemarks"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/Remark"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/CustomerReferenceInfo"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/AssociatedProfiles"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/AssociatedFilters"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/AssociatedTemplate"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/PrefCollections/AirlinePref/AirportOriginPref"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/PrefCollections/AirlinePref/AirlineSeatPref"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/PrefCollections/AirlinePref/AirlineMealPref"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/PrefCollections/HotelPref/HotelChainPref"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/PrefCollections/HotelPref/HotelMealPref"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/PrefCollections/VehicleRentalPref/VehicleVendorPref"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/PrefCollections/TPA_MarketingPreference/NotificationPreference"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/PrefCollections/TPA_MarketingPreference/Consent"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/PrefCollections/TPA_MarketingPreference/PsychographicCategory"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/Discounts"/>
 *     &lt;xs:enumeration value="/Profile/TravelAgent/CustomDefinedData"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PartialChildDataType implements Serializable {
    __PROFILE_TPA_IDENTITY_LOGIN("/Profile/TPA_Identity/Login"), __PROFILE_TPA_IDENTITY_PROFILE_SUB_TYPE(
            "/Profile/TPA_Identity/ProfileSubType"), __PROFILE_TPA_IDENTITY_SECURITY_INFO(
            "/Profile/TPA_Identity/SecurityInfo"), __PROFILE_TRAVELER_CUSTOMER_ADDRESS(
            "/Profile/Traveler/Customer/Address"), __PROFILE_TRAVELER_CUSTOMER_DOCUMENT(
            "/Profile/Traveler/Customer/Document"), __PROFILE_TRAVELER_CUSTOMER_CUST_LOYALTY(
            "/Profile/Traveler/Customer/CustLoyalty"), __PROFILE_TRAVELER_CUSTOMER_EMAIL(
            "/Profile/Traveler/Customer/Email"), __PROFILE_TRAVELER_CUSTOMER_EMERGENCY_CONTACT_PERSON(
            "/Profile/Traveler/Customer/EmergencyContactPerson"), __PROFILE_TRAVELER_CUSTOMER_EMPLOYMENT_INFO(
            "/Profile/Traveler/Customer/EmploymentInfo"), __PROFILE_TRAVELER_CUSTOMER_PAYMENT_FORM(
            "/Profile/Traveler/Customer/PaymentForm"), __PROFILE_TRAVELER_CUSTOMER_PERSON_NAME(
            "/Profile/Traveler/Customer/PersonName"), __PROFILE_TRAVELER_CUSTOMER_RELATED_TRAVELER(
            "/Profile/Traveler/Customer/RelatedTraveler"), __PROFILE_TRAVELER_CUSTOMER_TELEPHONE(
            "/Profile/Traveler/Customer/Telephone"), __PROFILE_TRAVELER_PREF_COLLECTIONS_AIRLINE_PREF_AIRLINE_CABIN_PREF(
            "/Profile/Traveler/PrefCollections/AirlinePref/AirlineCabinPref"), __PROFILE_TRAVELER_PREF_COLLECTIONS_AIRLINE_PREF_AIRLINE_MEAL_PREF(
            "/Profile/Traveler/PrefCollections/AirlinePref/AirlineMealPref"), __PROFILE_TRAVELER_PREF_COLLECTIONS_AIRLINE_PREF_AIRLINE_SEAT_PREF(
            "/Profile/Traveler/PrefCollections/AirlinePref/AirlineSeatPref"), __PROFILE_TRAVELER_PREF_COLLECTIONS_AIRLINE_PREF_AIRLINE_UPGRADE_PREF(
            "/Profile/Traveler/PrefCollections/AirlinePref/AirlineUpgradePref"), __PROFILE_TRAVELER_PREF_COLLECTIONS_AIRLINE_PREF_AIRPORT_PREF(
            "/Profile/Traveler/PrefCollections/AirlinePref/AirportPref"), __PROFILE_TRAVELER_PREF_COLLECTIONS_AIRLINE_PREF_PREFERRED_AGGREGATOR(
            "/Profile/Traveler/PrefCollections/AirlinePref/PreferredAggregator"), __PROFILE_TRAVELER_PREF_COLLECTIONS_AIRLINE_PREF_PREFERRED_AIRLINES(
            "/Profile/Traveler/PrefCollections/AirlinePref/PreferredAirlines"), __PROFILE_TRAVELER_PREF_COLLECTIONS_HOTEL_PREF_PREFERRED_AGGREGATOR(
            "/Profile/Traveler/PrefCollections/HotelPref/PreferredAggregator"), __PROFILE_TRAVELER_PREF_COLLECTIONS_HOTEL_PREF_PREFERRED_HOTEL(
            "/Profile/Traveler/PrefCollections/HotelPref/PreferredHotel"), __PROFILE_TRAVELER_PREF_COLLECTIONS_VEHICLE_RENTAL_PREF_PREFERRED_AGGREGATOR(
            "/Profile/Traveler/PrefCollections/VehicleRentalPref/PreferredAggregator"), __PROFILE_TRAVELER_PREF_COLLECTIONS_VEHICLE_RENTAL_PREF_PREFERRED_VEHICLE_VENDORS(
            "/Profile/Traveler/PrefCollections/VehicleRentalPref/PreferredVehicleVendors"), __PROFILE_TRAVELER_PREF_COLLECTIONS_TPA_MARKETING_PREFERENCE_NOTIFICATION_PREFERENCE(
            "/Profile/Traveler/PrefCollections/TPA_MarketingPreference/NotificationPreference"), __PROFILE_TRAVELER_PREF_COLLECTIONS_TPA_MARKETING_PREFERENCE_CONSENT(
            "/Profile/Traveler/PrefCollections/TPA_MarketingPreference/Consent"), __PROFILE_TRAVELER_PREF_COLLECTIONS_TPA_MARKETING_PREFERENCE_PSYCHOGRAPHIC_CATEGORY(
            "/Profile/Traveler/PrefCollections/TPA_MarketingPreference/PsychographicCategory"), __PROFILE_TRAVELER_TPA_EXTENSIONS_PRIORITY_REMARKS(
            "/Profile/Traveler/TPA_Extensions/PriorityRemarks"), __PROFILE_TRAVELER_TPA_EXTENSIONS_REMARK(
            "/Profile/Traveler/TPA_Extensions/Remark"), __PROFILE_TRAVELER_TPA_EXTENSIONS_SSR(
            "/Profile/Traveler/TPA_Extensions/SSR"), __PROFILE_TRAVELER_TPA_EXTENSIONS_OSI(
            "/Profile/Traveler/TPA_Extensions/OSI"), __PROFILE_TRAVELER_TPA_EXTENSIONS_CUSTOMER_REFERENCE_INFO(
            "/Profile/Traveler/TPA_Extensions/CustomerReferenceInfo"), __PROFILE_TRAVELER_TPA_EXTENSIONS_ASSOCIATED_PROFILES(
            "/Profile/Traveler/TPA_Extensions/AssociatedProfiles"), __PROFILE_TRAVELER_TPA_EXTENSIONS_ASSOCIATED_FILTERS(
            "/Profile/Traveler/TPA_Extensions/AssociatedFilters"), __PROFILE_TRAVELER_TPA_EXTENSIONS_ASSOCIATED_TEMPLATE(
            "/Profile/Traveler/TPA_Extensions/AssociatedTemplate"), __PROFILE_TRAVELER_TPA_EXTENSIONS_DISCOUNTS(
            "/Profile/Traveler/TPA_Extensions/Discounts"), __PROFILE_TRAVELER_TPA_EXTENSIONS_CUSTOM_DEFINED_DATA(
            "/Profile/Traveler/TPA_Extensions/CustomDefinedData"), __PROFILE_TRAVELER_TPA_EXTENSIONS_CUSTOMER_VALUE_SCORE(
            "/Profile/Traveler/TPA_Extensions/CustomerValueScore"), __PROFILE_TRAVELER_TPA_EXTENSIONS_TRAVEL_POLICY_SABRE_TRAVEL_POLICY_POLICY(
            "/Profile/Traveler/TPA_Extensions/TravelPolicy/SabreTravelPolicy/Policy"), __PROFILE_TRAVELER_TPA_EXTENSIONS_TRAVEL_POLICY_SABRE_TRAVEL_POLICY_PREFERENCE(
            "/Profile/Traveler/TPA_Extensions/TravelPolicy/SabreTravelPolicy/Preference"), __PROFILE_TRAVEL_AGENCY_TRAVEL_POLICY_SABRE_TRAVEL_POLICY_POLICY(
            "/Profile/TravelAgency/TravelPolicy/SabreTravelPolicy/Policy"), __PROFILE_TRAVEL_AGENCY_TRAVEL_POLICY_SABRE_TRAVEL_POLICY_PREFERENCE(
            "/Profile/TravelAgency/TravelPolicy/SabreTravelPolicy/Preference"), __PROFILE_CORPORATION_TRAVEL_POLICY_SABRE_TRAVEL_POLICY_POLICY(
            "/Profile/Corporation/TravelPolicy/SabreTravelPolicy/Policy"), __PROFILE_CORPORATION_TRAVEL_POLICY_SABRE_TRAVEL_POLICY_PREFERENCE(
            "/Profile/Corporation/TravelPolicy/SabreTravelPolicy/Preference"), __PROFILE_GROUP_PROFILE_TRAVEL_POLICY_SABRE_TRAVEL_POLICY_POLICY(
            "/Profile/GroupProfile/TravelPolicy/SabreTravelPolicy/Policy"), __PROFILE_GROUP_PROFILE_TRAVEL_POLICY_SABRE_TRAVEL_POLICY_PREFERENCE(
            "/Profile/GroupProfile/TravelPolicy/SabreTravelPolicy/Preference"), __PROFILE_GROUP_PROFILE_PAYMENT_FORM(
            "/Profile/GroupProfile/PaymentForm"), __PROFILE_OPERATIONAL_PROFILE_TRAVEL_POLICY_SABRE_TRAVEL_POLICY_POLICY(
            "/Profile/OperationalProfile/TravelPolicy/SabreTravelPolicy/Policy"), __PROFILE_OPERATIONAL_PROFILE_TRAVEL_POLICY_SABRE_TRAVEL_POLICY_PREFERENCE(
            "/Profile/OperationalProfile/TravelPolicy/SabreTravelPolicy/Preference"), __PROFILE_OPERATIONAL_PROFILE_PAYMENT_FORM(
            "/Profile/OperationalProfile/PaymentForm"), __PROFILE_TRAVEL_AGENCY_AGENCY_CONTACT_NAME(
            "/Profile/TravelAgency/AgencyContactName"), __PROFILE_TRAVEL_AGENCY_AGENCY_INFO(
            "/Profile/TravelAgency/AgencyInfo"), __PROFILE_TRAVEL_AGENCY_TELEPHONE(
            "/Profile/TravelAgency/Telephone"), __PROFILE_TRAVEL_AGENCY_EMAIL(
            "/Profile/TravelAgency/Email"), __PROFILE_TRAVEL_AGENCY_ADDRESS(
            "/Profile/TravelAgency/Address"), __PROFILE_TRAVEL_AGENCY_PAYMENT_FORM(
            "/Profile/TravelAgency/PaymentForm"), __PROFILE_TRAVEL_AGENCY_EMERGENCY_CONTACT_PERSON(
            "/Profile/TravelAgency/EmergencyContactPerson"), __PROFILE_TRAVEL_AGENCY_GDS(
            "/Profile/TravelAgency/GDS"), __PROFILE_TRAVEL_AGENCY_OTHER_SYSTEM_IDENTITY_INFO(
            "/Profile/TravelAgency/OtherSystemIdentityInfo"), __PROFILE_TRAVEL_AGENCY_BRANDING(
            "/Profile/TravelAgency/Branding"), __PROFILE_TRAVEL_AGENCY_PRIORITY_REMARKS(
            "/Profile/TravelAgency/PriorityRemarks"), __PROFILE_TRAVEL_AGENCY_REMARK(
            "/Profile/TravelAgency/Remark"), __PROFILE_TRAVEL_AGENCY_CUSTOMER_REFERENCE_INFO(
            "/Profile/TravelAgency/CustomerReferenceInfo"), __PROFILE_TRAVEL_AGENCY_ASSOCIATED_PROFILES(
            "/Profile/TravelAgency/AssociatedProfiles"), __PROFILE_TRAVEL_AGENCY_ASSOCIATED_FILTERS(
            "/Profile/TravelAgency/AssociatedFilters"), __PROFILE_TRAVEL_AGENCY_ASSOCIATED_TEMPLATE(
            "/Profile/TravelAgency/AssociatedTemplate"), __PROFILE_TRAVEL_AGENCY_PREF_COLLECTIONS_AIRLINE_PREF_AIRPORT_ORIGIN_PREF(
            "/Profile/TravelAgency/PrefCollections/AirlinePref/AirportOriginPref"), __PROFILE_TRAVEL_AGENCY_PREF_COLLECTIONS_AIRLINE_PREF_AIRLINE_SEAT_PREF(
            "/Profile/TravelAgency/PrefCollections/AirlinePref/AirlineSeatPref"), __PROFILE_TRAVEL_AGENCY_PREF_COLLECTIONS_AIRLINE_PREF_AIRLINE_MEAL_PREF(
            "/Profile/TravelAgency/PrefCollections/AirlinePref/AirlineMealPref"), __PROFILE_TRAVEL_AGENCY_PREF_COLLECTIONS_HOTEL_PREF_HOTEL_CHAIN_PREF(
            "/Profile/TravelAgency/PrefCollections/HotelPref/HotelChainPref"), __PROFILE_TRAVEL_AGENCY_PREF_COLLECTIONS_HOTEL_PREF_HOTEL_MEAL_PREF(
            "/Profile/TravelAgency/PrefCollections/HotelPref/HotelMealPref"), __PROFILE_TRAVEL_AGENCY_PREF_COLLECTIONS_VEHICLE_RENTAL_PREF_VEHICLE_VENDOR_PREF(
            "/Profile/TravelAgency/PrefCollections/VehicleRentalPref/VehicleVendorPref"), __PROFILE_TRAVEL_AGENCY_PREF_COLLECTIONS_TPA_MARKETING_PREFERENCE_NOTIFICATION_PREFERENCE(
            "/Profile/TravelAgency/PrefCollections/TPA_MarketingPreference/NotificationPreference"), __PROFILE_TRAVEL_AGENCY_PREF_COLLECTIONS_TPA_MARKETING_PREFERENCE_CONSENT(
            "/Profile/TravelAgency/PrefCollections/TPA_MarketingPreference/Consent"), __PROFILE_TRAVEL_AGENCY_PREF_COLLECTIONS_TPA_MARKETING_PREFERENCE_PSYCHOGRAPHIC_CATEGORY(
            "/Profile/TravelAgency/PrefCollections/TPA_MarketingPreference/PsychographicCategory"), __PROFILE_TRAVEL_AGENCY_DISCOUNTS(
            "/Profile/TravelAgency/Discounts"), __PROFILE_TRAVEL_AGENCY_CUSTOM_DEFINED_DATA(
            "/Profile/TravelAgency/CustomDefinedData"), __PROFILE_CORPORATION_CORPORATE_INFO(
            "/Profile/Corporation/CorporateInfo"), __PROFILE_CORPORATION_CONTACT_NAME(
            "/Profile/Corporation/ContactName"), __PROFILE_CORPORATION_TELEPHONE(
            "/Profile/Corporation/Telephone"), __PROFILE_CORPORATION_EMAIL(
            "/Profile/Corporation/Email"), __PROFILE_CORPORATION_ADDRESS(
            "/Profile/Corporation/Address"), __PROFILE_CORPORATION_PAYMENT_FORM(
            "/Profile/Corporation/PaymentForm"), __PROFILE_CORPORATION_EMERGENCY_CONTACT_PERSON(
            "/Profile/Corporation/EmergencyContactPerson"), __PROFILE_CORPORATION_SALES_MANAGER(
            "/Profile/Corporation/SalesManager"), __PROFILE_CORPORATION_PRIORITY_REMARKS(
            "/Profile/Corporation/PriorityRemarks"), __PROFILE_CORPORATION_REMARK(
            "/Profile/Corporation/Remark"), __PROFILE_CORPORATION_CUSTOMER_REFERENCE_INFO(
            "/Profile/Corporation/CustomerReferenceInfo"), __PROFILE_CORPORATION_ASSOCIATED_PROFILES(
            "/Profile/Corporation/AssociatedProfiles"), __PROFILE_CORPORATION_ASSOCIATED_FILTERS(
            "/Profile/Corporation/AssociatedFilters"), __PROFILE_CORPORATION_ASSOCIATED_TEMPLATE(
            "/Profile/Corporation/AssociatedTemplate"), __PROFILE_CORPORATION_PREF_COLLECTIONS_AIRLINE_PREF_AIRPORT_ORIGIN_PREF(
            "/Profile/Corporation/PrefCollections/AirlinePref/AirportOriginPref"), __PROFILE_CORPORATION_PREF_COLLECTIONS_AIRLINE_PREF_AIRLINE_SEAT_PREF(
            "/Profile/Corporation/PrefCollections/AirlinePref/AirlineSeatPref"), __PROFILE_CORPORATION_PREF_COLLECTIONS_AIRLINE_PREF_AIRLINE_MEAL_PREF(
            "/Profile/Corporation/PrefCollections/AirlinePref/AirlineMealPref"), __PROFILE_CORPORATION_PREF_COLLECTIONS_HOTEL_PREF_HOTEL_CHAIN_PREF(
            "/Profile/Corporation/PrefCollections/HotelPref/HotelChainPref"), __PROFILE_CORPORATION_PREF_COLLECTIONS_HOTEL_PREF_HOTEL_MEAL_PREF(
            "/Profile/Corporation/PrefCollections/HotelPref/HotelMealPref"), __PROFILE_CORPORATION_PREF_COLLECTIONS_VEHICLE_RENTAL_PREF_VEHICLE_VENDOR_PREF(
            "/Profile/Corporation/PrefCollections/VehicleRentalPref/VehicleVendorPref"), __PROFILE_CORPORATION_PREF_COLLECTIONS_TPA_MARKETING_PREFERENCE_NOTIFICATION_PREFERENCE(
            "/Profile/Corporation/PrefCollections/TPA_MarketingPreference/NotificationPreference"), __PROFILE_CORPORATION_PREF_COLLECTIONS_TPA_MARKETING_PREFERENCE_CONSENT(
            "/Profile/Corporation/PrefCollections/TPA_MarketingPreference/Consent"), __PROFILE_CORPORATION_PREF_COLLECTIONS_TPA_MARKETING_PREFERENCE_PSYCHOGRAPHIC_CATEGORY(
            "/Profile/Corporation/PrefCollections/TPA_MarketingPreference/PsychographicCategory"), __PROFILE_TRAVELER_PREF_COLLECTIONS_LOUNGE_PREF(
            "/Profile/Traveler/PrefCollections/LoungePref"), __PROFILE_CORPORATION_DISCOUNTS(
            "/Profile/Corporation/Discounts"), __PROFILE_CORPORATION_CUSTOM_DEFINED_DATA(
            "/Profile/Corporation/CustomDefinedData"), __PROFILE_TRAVEL_AGENT_AGENT_NAME(
            "/Profile/TravelAgent/AgentName"), __PROFILE_TRAVEL_AGENT_AGENT_INFO(
            "/Profile/TravelAgent/AgentInfo"), __PROFILE_TRAVEL_AGENT_OTHER_SYSTEM_IDENTITY_INFO(
            "/Profile/TravelAgent/OtherSystemIdentityInfo"), __PROFILE_TRAVEL_AGENT_TELEPHONE(
            "/Profile/TravelAgent/Telephone"), __PROFILE_TRAVEL_AGENT_EMAIL(
            "/Profile/TravelAgent/Email"), __PROFILE_TRAVEL_AGENT_ADDRESS(
            "/Profile/TravelAgent/Address"), __PROFILE_TRAVEL_AGENT_PAYMENT_FORM(
            "/Profile/TravelAgent/PaymentForm"), __PROFILE_TRAVEL_AGENT_AGENT_RELATED_NAMES(
            "/Profile/TravelAgent/AgentRelatedNames"), __PROFILE_TRAVEL_AGENT_EMERGENCY_CONTACT_PERSON(
            "/Profile/TravelAgent/EmergencyContactPerson"), __PROFILE_TRAVEL_AGENT_DOCUMENT(
            "/Profile/TravelAgent/Document"), __PROFILE_TRAVEL_AGENT_CUST_LOYALTY(
            "/Profile/TravelAgent/CustLoyalty"), __PROFILE_TRAVEL_AGENT_EMPLOYMENT_INFO(
            "/Profile/TravelAgent/EmploymentInfo"), __PROFILE_TRAVEL_AGENT_GDS(
            "/Profile/TravelAgent/GDS"), __PROFILE_TRAVEL_AGENT_PRIORITY_REMARKS(
            "/Profile/TravelAgent/PriorityRemarks"), __PROFILE_TRAVEL_AGENT_REMARK(
            "/Profile/TravelAgent/Remark"), __PROFILE_TRAVEL_AGENT_CUSTOMER_REFERENCE_INFO(
            "/Profile/TravelAgent/CustomerReferenceInfo"), __PROFILE_TRAVEL_AGENT_ASSOCIATED_PROFILES(
            "/Profile/TravelAgent/AssociatedProfiles"), __PROFILE_TRAVEL_AGENT_ASSOCIATED_FILTERS(
            "/Profile/TravelAgent/AssociatedFilters"), __PROFILE_TRAVEL_AGENT_ASSOCIATED_TEMPLATE(
            "/Profile/TravelAgent/AssociatedTemplate"), __PROFILE_TRAVEL_AGENT_PREF_COLLECTIONS_AIRLINE_PREF_AIRPORT_ORIGIN_PREF(
            "/Profile/TravelAgent/PrefCollections/AirlinePref/AirportOriginPref"), __PROFILE_TRAVEL_AGENT_PREF_COLLECTIONS_AIRLINE_PREF_AIRLINE_SEAT_PREF(
            "/Profile/TravelAgent/PrefCollections/AirlinePref/AirlineSeatPref"), __PROFILE_TRAVEL_AGENT_PREF_COLLECTIONS_AIRLINE_PREF_AIRLINE_MEAL_PREF(
            "/Profile/TravelAgent/PrefCollections/AirlinePref/AirlineMealPref"), __PROFILE_TRAVEL_AGENT_PREF_COLLECTIONS_HOTEL_PREF_HOTEL_CHAIN_PREF(
            "/Profile/TravelAgent/PrefCollections/HotelPref/HotelChainPref"), __PROFILE_TRAVEL_AGENT_PREF_COLLECTIONS_HOTEL_PREF_HOTEL_MEAL_PREF(
            "/Profile/TravelAgent/PrefCollections/HotelPref/HotelMealPref"), __PROFILE_TRAVEL_AGENT_PREF_COLLECTIONS_VEHICLE_RENTAL_PREF_VEHICLE_VENDOR_PREF(
            "/Profile/TravelAgent/PrefCollections/VehicleRentalPref/VehicleVendorPref"), __PROFILE_TRAVEL_AGENT_PREF_COLLECTIONS_TPA_MARKETING_PREFERENCE_NOTIFICATION_PREFERENCE(
            "/Profile/TravelAgent/PrefCollections/TPA_MarketingPreference/NotificationPreference"), __PROFILE_TRAVEL_AGENT_PREF_COLLECTIONS_TPA_MARKETING_PREFERENCE_CONSENT(
            "/Profile/TravelAgent/PrefCollections/TPA_MarketingPreference/Consent"), __PROFILE_TRAVEL_AGENT_PREF_COLLECTIONS_TPA_MARKETING_PREFERENCE_PSYCHOGRAPHIC_CATEGORY(
            "/Profile/TravelAgent/PrefCollections/TPA_MarketingPreference/PsychographicCategory"), __PROFILE_TRAVEL_AGENT_DISCOUNTS(
            "/Profile/TravelAgent/Discounts"), __PROFILE_TRAVEL_AGENT_CUSTOM_DEFINED_DATA(
            "/Profile/TravelAgent/CustomDefinedData");
    private final String value;

    private PartialChildDataType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PartialChildDataType convert(String value) {
        for (PartialChildDataType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
