
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PartialLoungePrefType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PreferredDrinkType" name="PreferredDrink" minOccurs="0" maxOccurs="10"/>
 *     &lt;xs:element type="ns:PreferredNewspaperType" name="PreferredNewspaper" minOccurs="0" maxOccurs="10"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="TripTypeCode"/>
 *   &lt;xs:attribute type="xs:string" name="VendorTypeCode"/>
 *   &lt;xs:attribute type="xs:string" name="VendorCode"/>
 *   &lt;xs:attribute type="xs:string" name="DisplaySequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PartialLoungePrefType implements Serializable
{
    private List<PreferredDrinkType> preferredDrinkList = new ArrayList<PreferredDrinkType>();
    private List<PreferredNewspaperType> preferredNewspaperList = new ArrayList<PreferredNewspaperType>();
    private String tripTypeCode;
    private String vendorTypeCode;
    private String vendorCode;
    private String displaySequenceNo;

    /** 
     * Get the list of 'PreferredDrink' element items. ***SABRE ADDED*** Stores List of preferred drinks
     * 
     * @return list
     */
    public List<PreferredDrinkType> getPreferredDrinkList() {
        return preferredDrinkList;
    }

    /** 
     * Set the list of 'PreferredDrink' element items. ***SABRE ADDED*** Stores List of preferred drinks
     * 
     * @param list
     */
    public void setPreferredDrinkList(List<PreferredDrinkType> list) {
        preferredDrinkList = list;
    }

    /** 
     * Get the list of 'PreferredNewspaper' element items. ***SABRE ADDED*** Stores List of preferred newspapers
     * 
     * @return list
     */
    public List<PreferredNewspaperType> getPreferredNewspaperList() {
        return preferredNewspaperList;
    }

    /** 
     * Set the list of 'PreferredNewspaper' element items. ***SABRE ADDED*** Stores List of preferred newspapers
     * 
     * @param list
     */
    public void setPreferredNewspaperList(List<PreferredNewspaperType> list) {
        preferredNewspaperList = list;
    }

    /** 
     * Get the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @return value
     */
    public String getTripTypeCode() {
        return tripTypeCode;
    }

    /** 
     * Set the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @param tripTypeCode
     */
    public void setTripTypeCode(String tripTypeCode) {
        this.tripTypeCode = tripTypeCode;
    }

    /** 
     * Get the 'VendorTypeCode' attribute value. Represents a classification of Industry Service providers, like AS
     * 
     * @return value
     */
    public String getVendorTypeCode() {
        return vendorTypeCode;
    }

    /** 
     * Set the 'VendorTypeCode' attribute value. Represents a classification of Industry Service providers, like AS
     * 
     * @param vendorTypeCode
     */
    public void setVendorTypeCode(String vendorTypeCode) {
        this.vendorTypeCode = vendorTypeCode;
    }

    /** 
     * Get the 'VendorCode' attribute value. Identifier to indicate the owner of the lounge
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' attribute value. Identifier to indicate the owner of the lounge
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }
}
