
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Identifes the attribute names that can be ignored during partial update
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PartialUpdateIgnoredAttributeNamesType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="OrderSequenceNo"/>
 *     &lt;xs:enumeration value="DisplaySequenceNo"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PartialUpdateIgnoredAttributeNamesType implements Serializable {
    ORDER_SEQUENCE_NO("OrderSequenceNo"), DISPLAY_SEQUENCE_NO(
            "DisplaySequenceNo");
    private final String value;

    private PartialUpdateIgnoredAttributeNamesType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PartialUpdateIgnoredAttributeNamesType convert(String value) {
        for (PartialUpdateIgnoredAttributeNamesType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
