
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * subtree to support partial updates
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PartialUpdatesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TPAIdentityType" name="TPA_Identity"/>
 *     &lt;xs:element name="Delete" minOccurs="0">
 *       &lt;!-- Reference to inner class Delete -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Add" minOccurs="0">
 *       &lt;!-- Reference to inner class Add -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Modify" minOccurs="0">
 *       &lt;!-- Reference to inner class Modify -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PartialUpdatesType implements Serializable
{
    private TPAIdentityType TPAIdentity;
    private Delete delete;
    private Add add;
    private Modify modify;

    /** 
     * Get the 'TPA_Identity' element value. *** SABRE ADDED *** Identity of a profile
     * 
     * @return value
     */
    public TPAIdentityType getTPAIdentity() {
        return TPAIdentity;
    }

    /** 
     * Set the 'TPA_Identity' element value. *** SABRE ADDED *** Identity of a profile
     * 
     * @param TPAIdentity
     */
    public void setTPAIdentity(TPAIdentityType TPAIdentity) {
        this.TPAIdentity = TPAIdentity;
    }

    /** 
     * Get the 'Delete' element value.
     * 
     * @return value
     */
    public Delete getDelete() {
        return delete;
    }

    /** 
     * Set the 'Delete' element value.
     * 
     * @param delete
     */
    public void setDelete(Delete delete) {
        this.delete = delete;
    }

    /** 
     * Get the 'Add' element value.
     * 
     * @return value
     */
    public Add getAdd() {
        return add;
    }

    /** 
     * Set the 'Add' element value.
     * 
     * @param add
     */
    public void setAdd(Add add) {
        this.add = add;
    }

    /** 
     * Get the 'Modify' element value.
     * 
     * @return value
     */
    public Modify getModify() {
        return modify;
    }

    /** 
     * Set the 'Modify' element value.
     * 
     * @param modify
     */
    public void setModify(Modify modify) {
        this.modify = modify;
    }
    /** 
     * *** SABRE ADDED *** partial Delete of a profile 
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Delete" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:DeleteSubtreeType" name="DeleteSubtree" minOccurs="0" maxOccurs="200"/>
     *       &lt;xs:element type="ns:DeleteElementType" name="DeleteElement" minOccurs="0" maxOccurs="2"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Delete implements Serializable
    {
        private List<DeleteSubtreeType> deleteSubtreeList = new ArrayList<DeleteSubtreeType>();
        private List<DeleteElementType> deleteElementList = new ArrayList<DeleteElementType>();

        /** 
         * Get the list of 'DeleteSubtree' element items. *** SABRE ADDED *** partial Delete Sub Tree of a profile
         * 
         * @return list
         */
        public List<DeleteSubtreeType> getDeleteSubtreeList() {
            return deleteSubtreeList;
        }

        /** 
         * Set the list of 'DeleteSubtree' element items. *** SABRE ADDED *** partial Delete Sub Tree of a profile
         * 
         * @param list
         */
        public void setDeleteSubtreeList(List<DeleteSubtreeType> list) {
            deleteSubtreeList = list;
        }

        /** 
         * Get the list of 'DeleteElement' element items. *** SABRE ADDED *** Partial Delete Elements of a profile
         * 
         * @return list
         */
        public List<DeleteElementType> getDeleteElementList() {
            return deleteElementList;
        }

        /** 
         * Set the list of 'DeleteElement' element items. *** SABRE ADDED *** Partial Delete Elements of a profile
         * 
         * @param list
         */
        public void setDeleteElementList(List<DeleteElementType> list) {
            deleteElementList = list;
        }
    }
    /** 
     * *** SABRE ADDED *** Partial Add data to a profile 
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Add" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:AddSubtreeType" name="AddSubtree" minOccurs="0" maxOccurs="200"/>
     *       &lt;xs:element type="ns:AddElementType" name="AddElement" minOccurs="0" maxOccurs="2"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Add implements Serializable
    {
        private List<AddSubtreeType> addSubtreeList = new ArrayList<AddSubtreeType>();
        private List<AddElementType> addElementList = new ArrayList<AddElementType>();

        /** 
         * Get the list of 'AddSubtree' element items. *** SABRE ADDED *** Partial Add Sub Tree to a profile
         * 
         * @return list
         */
        public List<AddSubtreeType> getAddSubtreeList() {
            return addSubtreeList;
        }

        /** 
         * Set the list of 'AddSubtree' element items. *** SABRE ADDED *** Partial Add Sub Tree to a profile
         * 
         * @param list
         */
        public void setAddSubtreeList(List<AddSubtreeType> list) {
            addSubtreeList = list;
        }

        /** 
         * Get the list of 'AddElement' element items. *** SABRE ADDED *** Partial Add Elements to a profile
         * 
         * @return list
         */
        public List<AddElementType> getAddElementList() {
            return addElementList;
        }

        /** 
         * Set the list of 'AddElement' element items. *** SABRE ADDED *** Partial Add Elements to a profile
         * 
         * @param list
         */
        public void setAddElementList(List<AddElementType> list) {
            addElementList = list;
        }
    }
    /** 
     * *** SABRE ADDED *** Partial Modify  data to a profile 
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Modify" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:ModifySubtreeType" name="ModifySubtree" minOccurs="0" maxOccurs="200"/>
     *       &lt;xs:element type="ns:ModifyElementType" name="ModifyElement" minOccurs="0" maxOccurs="2"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Modify implements Serializable
    {
        private List<ModifySubtreeType> modifySubtreeList = new ArrayList<ModifySubtreeType>();
        private List<ModifyElementType> modifyElementList = new ArrayList<ModifyElementType>();

        /** 
         * Get the list of 'ModifySubtree' element items. *** SABRE ADDED *** Partial Modify Sub Tree to a profile
         * 
         * @return list
         */
        public List<ModifySubtreeType> getModifySubtreeList() {
            return modifySubtreeList;
        }

        /** 
         * Set the list of 'ModifySubtree' element items. *** SABRE ADDED *** Partial Modify Sub Tree to a profile
         * 
         * @param list
         */
        public void setModifySubtreeList(List<ModifySubtreeType> list) {
            modifySubtreeList = list;
        }

        /** 
         * Get the list of 'ModifyElement' element items. *** SABRE ADDED *** Partial Modify  Elements to a profile
         * 
         * @return list
         */
        public List<ModifyElementType> getModifyElementList() {
            return modifyElementList;
        }

        /** 
         * Set the list of 'ModifyElement' element items. *** SABRE ADDED *** Partial Modify  Elements to a profile
         * 
         * @param list
         */
        public void setModifyElementList(List<ModifyElementType> list) {
            modifyElementList = list;
        }
    }
}
