
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Identification about a specific credit card
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCardType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CardHolderNameType" name="CardHolderName" minOccurs="0"/>
 *     &lt;xs:element name="CardIssuerName" minOccurs="0">
 *       &lt;!-- Reference to inner class CardIssuerName -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0" maxOccurs="5"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CardTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="BankCardVendorCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="CardNumber"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="MaskedCardNumber"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="CCViewAccess"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EffectiveDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ExpireDate"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="FirstRemark"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ExtendedPaymentNumMonths"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentCardType implements Serializable
{
    private CardHolderNameType cardHolderName;
    private CardIssuerName cardIssuerName;
    private List<AddressType> addressList = new ArrayList<AddressType>();
    private String cardTypeCode;
    private String bankCardVendorCode;
    private String cardNumber;
    private String maskedCardNumber;
    private YesNoType CCViewAccess;
    private String effectiveDate;
    private String expireDate;
    private YesNoType firstRemark;
    private String extendedPaymentNumMonths;

    /** 
     * Get the 'CardHolderName' element value. Name of the card holder.
     * 
     * @return value
     */
    public CardHolderNameType getCardHolderName() {
        return cardHolderName;
    }

    /** 
     * Set the 'CardHolderName' element value. Name of the card holder.
     * 
     * @param cardHolderName
     */
    public void setCardHolderName(CardHolderNameType cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    /** 
     * Get the 'CardIssuerName' element value.
     * 
     * @return value
     */
    public CardIssuerName getCardIssuerName() {
        return cardIssuerName;
    }

    /** 
     * Set the 'CardIssuerName' element value.
     * 
     * @param cardIssuerName
     */
    public void setCardIssuerName(CardIssuerName cardIssuerName) {
        this.cardIssuerName = cardIssuerName;
    }

    /** 
     * Get the list of 'Address' element items. Card holder's address.
     * 
     * @return list
     */
    public List<AddressType> getAddressList() {
        return addressList;
    }

    /** 
     * Set the list of 'Address' element items. Card holder's address.
     * 
     * @param list
     */
    public void setAddressList(List<AddressType> list) {
        addressList = list;
    }

    /** 
     * Get the 'CardTypeCode' attribute value. The Type of card like DB(debit)/CC(credit) etc.
    [BANK_CARD.BANK_CARD_USG_CD]
     * 
     * @return value
     */
    public String getCardTypeCode() {
        return cardTypeCode;
    }

    /** 
     * Set the 'CardTypeCode' attribute value. The Type of card like DB(debit)/CC(credit) etc.
    [BANK_CARD.BANK_CARD_USG_CD]
     * 
     * @param cardTypeCode
     */
    public void setCardTypeCode(String cardTypeCode) {
        this.cardTypeCode = cardTypeCode;
    }

    /** 
     * Get the 'BankCardVendorCode' attribute value. The 2 character code of the credit card issuer.
     * 
     * @return value
     */
    public String getBankCardVendorCode() {
        return bankCardVendorCode;
    }

    /** 
     * Set the 'BankCardVendorCode' attribute value. The 2 character code of the credit card issuer.
     * 
     * @param bankCardVendorCode
     */
    public void setBankCardVendorCode(String bankCardVendorCode) {
        this.bankCardVendorCode = bankCardVendorCode;
    }

    /** 
     * Get the 'CardNumber' attribute value. Credit card number embossed on the card.
     * 
     * @return value
     */
    public String getCardNumber() {
        return cardNumber;
    }

    /** 
     * Set the 'CardNumber' attribute value. Credit card number embossed on the card.
     * 
     * @param cardNumber
     */
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    /** 
     * Get the 'MaskedCardNumber' attribute value. Masked Credit card number embossed on the card.
     * 
     * @return value
     */
    public String getMaskedCardNumber() {
        return maskedCardNumber;
    }

    /** 
     * Set the 'MaskedCardNumber' attribute value. Masked Credit card number embossed on the card.
     * 
     * @param maskedCardNumber
     */
    public void setMaskedCardNumber(String maskedCardNumber) {
        this.maskedCardNumber = maskedCardNumber;
    }

    /** 
     * Get the 'CCViewAccess' attribute value. Indicates whether the user has access to view Credit Card or not
     * 
     * @return value
     */
    public YesNoType getCCViewAccess() {
        return CCViewAccess;
    }

    /** 
     * Set the 'CCViewAccess' attribute value. Indicates whether the user has access to view Credit Card or not
     * 
     * @param CCViewAccess
     */
    public void setCCViewAccess(YesNoType CCViewAccess) {
        this.CCViewAccess = CCViewAccess;
    }

    /** 
     * Get the 'EffectiveDate' attribute value. Indicates the starting date.
     * 
     * @return value
     */
    public String getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' attribute value. Indicates the starting date.
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'ExpireDate' attribute value. Indicates the ending date.
     * 
     * @return value
     */
    public String getExpireDate() {
        return expireDate;
    }

    /** 
     * Set the 'ExpireDate' attribute value. Indicates the ending date.
     * 
     * @param expireDate
     */
    public void setExpireDate(String expireDate) {
        this.expireDate = expireDate;
    }

    /** 
     * Get the 'FirstRemark' attribute value. First Remark indicator
     * 
     * @return value
     */
    public YesNoType getFirstRemark() {
        return firstRemark;
    }

    /** 
     * Set the 'FirstRemark' attribute value. First Remark indicator
     * 
     * @param firstRemark
     */
    public void setFirstRemark(YesNoType firstRemark) {
        this.firstRemark = firstRemark;
    }

    /** 
     * Get the 'ExtendedPaymentNumMonths' attribute value. Extended Payment number of months
     * 
     * @return value
     */
    public String getExtendedPaymentNumMonths() {
        return extendedPaymentNumMonths;
    }

    /** 
     * Set the 'ExtendedPaymentNumMonths' attribute value. Extended Payment number of months
     * 
     * @param extendedPaymentNumMonths
     */
    public void setExtendedPaymentNumMonths(String extendedPaymentNumMonths) {
        this.extendedPaymentNumMonths = extendedPaymentNumMonths;
    }
    /** 
     * Issuer of the card.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardIssuerName" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="IssueNumberText"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="IssuerName"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CardIssuerName implements Serializable
    {
        private String issueNumberText;
        private String issuerName;

        /** 
         * Get the 'IssueNumberText' attribute value. Issuer Number Text.
         * 
         * @return value
         */
        public String getIssueNumberText() {
            return issueNumberText;
        }

        /** 
         * Set the 'IssueNumberText' attribute value. Issuer Number Text.
         * 
         * @param issueNumberText
         */
        public void setIssueNumberText(String issueNumberText) {
            this.issueNumberText = issueNumberText;
        }

        /** 
         * Get the 'IssuerName' attribute value. Issuer Number Text.
         * 
         * @return value
         */
        public String getIssuerName() {
            return issuerName;
        }

        /** 
         * Set the 'IssuerName' attribute value. Issuer Number Text.
         * 
         * @param issuerName
         */
        public void setIssuerName(String issuerName) {
            this.issuerName = issuerName;
        }
    }
}
