
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Custom preference element with Code
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PreferenceType">
 *   &lt;xs:attribute type="xs:string" use="required" name="PrefCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="PrefCatCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VendorTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VendorID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PreferenceType implements Serializable
{
    private String prefCode;
    private String prefCatCode;
    private String vendorTypeCode;
    private String vendorID;
    private String orderSequenceNo;
    private String displaySequenceNo;

    /** 
     * Get the 'PrefCode' attribute value. Preference Code
     * 
     * @return value
     */
    public String getPrefCode() {
        return prefCode;
    }

    /** 
     * Set the 'PrefCode' attribute value. Preference Code
     * 
     * @param prefCode
     */
    public void setPrefCode(String prefCode) {
        this.prefCode = prefCode;
    }

    /** 
     * Get the 'PrefCatCode' attribute value. Preference Category Code
     * 
     * @return value
     */
    public String getPrefCatCode() {
        return prefCatCode;
    }

    /** 
     * Set the 'PrefCatCode' attribute value. Preference Category Code
     * 
     * @param prefCatCode
     */
    public void setPrefCatCode(String prefCatCode) {
        this.prefCatCode = prefCatCode;
    }

    /** 
     * Get the 'VendorTypeCode' attribute value. Preference owner type
     * 
     * @return value
     */
    public String getVendorTypeCode() {
        return vendorTypeCode;
    }

    /** 
     * Set the 'VendorTypeCode' attribute value. Preference owner type
     * 
     * @param vendorTypeCode
     */
    public void setVendorTypeCode(String vendorTypeCode) {
        this.vendorTypeCode = vendorTypeCode;
    }

    /** 
     * Get the 'VendorID' attribute value. Preference owner external identifier
     * 
     * @return value
     */
    public String getVendorID() {
        return vendorID;
    }

    /** 
     * Set the 'VendorID' attribute value. Preference owner external identifier
     * 
     * @param vendorID
     */
    public void setVendorID(String vendorID) {
        this.vendorID = vendorID;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value.
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value.
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }
}
