
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileAssociationType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociationIDType">
 *       &lt;xs:attribute type="xs:string" use="optional" name="AssociationDescription"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="AssociationName"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="ClientContextCode"/>
 *       &lt;xs:attribute type="ns:ProfileTypeInfo" use="optional" name="ProfileTypeCode"/>
 *       &lt;xs:attribute type="xs:dateTime" use="optional" name="CreateDateTime"/>
 *       &lt;xs:attribute type="xs:dateTime" use="optional" name="UpdateDateTime"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileAssociationType extends AssociationIDType implements
    Serializable
{
    private String associationDescription;
    private String associationName;
    private String clientContextCode;
    private ProfileTypeInfo profileTypeCode;
    private Date createDateTime;
    private Date updateDateTime;

    /** 
     * Get the 'AssociationDescription' attribute value. Description of an association if needed
     * 
     * @return value
     */
    public String getAssociationDescription() {
        return associationDescription;
    }

    /** 
     * Set the 'AssociationDescription' attribute value. Description of an association if needed
     * 
     * @param associationDescription
     */
    public void setAssociationDescription(String associationDescription) {
        this.associationDescription = associationDescription;
    }

    /** 
     * Get the 'AssociationName' attribute value. Name of the association
     * 
     * @return value
     */
    public String getAssociationName() {
        return associationName;
    }

    /** 
     * Set the 'AssociationName' attribute value. Name of the association
     * 
     * @param associationName
     */
    public void setAssociationName(String associationName) {
        this.associationName = associationName;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. ClientContextCode indicated calling applications ex: MYS, NTC
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. ClientContextCode indicated calling applications ex: MYS, NTC
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'ProfileTypeCode' attribute value. Profile type code, used to validate associated information
     * 
     * @return value
     */
    public ProfileTypeInfo getProfileTypeCode() {
        return profileTypeCode;
    }

    /** 
     * Set the 'ProfileTypeCode' attribute value. Profile type code, used to validate associated information
     * 
     * @param profileTypeCode
     */
    public void setProfileTypeCode(ProfileTypeInfo profileTypeCode) {
        this.profileTypeCode = profileTypeCode;
    }

    /** 
     * Get the 'CreateDateTime' attribute value. Timestamp data, constains information when association was created
     * 
     * @return value
     */
    public Date getCreateDateTime() {
        return createDateTime;
    }

    /** 
     * Set the 'CreateDateTime' attribute value. Timestamp data, constains information when association was created
     * 
     * @param createDateTime
     */
    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    /** 
     * Get the 'UpdateDateTime' attribute value. Timestamp data, constains information when association was updated last time
     * 
     * @return value
     */
    public Date getUpdateDateTime() {
        return updateDateTime;
    }

    /** 
     * Set the 'UpdateDateTime' attribute value. Timestamp data, constains information when association was updated last time
     * 
     * @param updateDateTime
     */
    public void setUpdateDateTime(Date updateDateTime) {
        this.updateDateTime = updateDateTime;
    }
}
