
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileBaseCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:SearchTPAIdentityType" name="TPA_Identity"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *     &lt;xs:element type="ns:SearchEmailType" name="Email" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchTelephoneType" name="Telephone" minOccurs="0"/>
 *     &lt;xs:element name="TaxInfo" minOccurs="0">
 *       &lt;!-- Reference to inner class TaxInfo -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:SearchAddressType" name="Address" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchCustLoyaltyType" name="CustLoyalty" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchCustomerReferenceInfoType" name="CustomerReferenceInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchBusinessSystemIdenitityInfo" name="BusinessSystemIdentityInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchAssociatedProfilesType" name="AssociatedProfiles" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:SearchOperationTypeInfo" use="optional" default="AND" name="SearchOperationType"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="ExcludeDeletedProfiles"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="IncludeAdminProfiles"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileBaseCriteriaType implements Serializable
{
    private SearchTPAIdentityType TPAIdentity;
    private Choice choice;
    private SearchEmailType email;
    private SearchTelephoneType telephone;
    private TaxInfo taxInfo;
    private SearchAddressType address;
    private SearchCustLoyaltyType custLoyalty;
    private SearchCustomerReferenceInfoType customerReferenceInfo;
    private SearchBusinessSystemIdenitityInfo businessSystemIdentityInfo;
    private SearchAssociatedProfilesType associatedProfiles;
    private SearchOperationTypeInfo searchOperationType;
    private YesNoType excludeDeletedProfiles;
    private YesNoType includeAdminProfiles;

    /** 
     * Get the 'TPA_Identity' element value. 
     ***SABRE ADDED*** To hold Identity information
    					of a profile
    				
     * 
     * @return value
     */
    public SearchTPAIdentityType getTPAIdentity() {
        return TPAIdentity;
    }

    /** 
     * Set the 'TPA_Identity' element value. 
     ***SABRE ADDED*** To hold Identity information
    					of a profile
    				
     * 
     * @param TPAIdentity
     */
    public void setTPAIdentity(SearchTPAIdentityType TPAIdentity) {
        this.TPAIdentity = TPAIdentity;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'Email' element value. 
     ***OTA Based *** Email Information
    				
     * 
     * @return value
     */
    public SearchEmailType getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value. 
     ***OTA Based *** Email Information
    				
     * 
     * @param email
     */
    public void setEmail(SearchEmailType email) {
        this.email = email;
    }

    /** 
     * Get the 'Telephone' element value. 
     ***OTA Based *** Phon Information
    				
     * 
     * @return value
     */
    public SearchTelephoneType getTelephone() {
        return telephone;
    }

    /** 
     * Set the 'Telephone' element value. 
     ***OTA Based *** Phon Information
    				
     * 
     * @param telephone
     */
    public void setTelephone(SearchTelephoneType telephone) {
        this.telephone = telephone;
    }

    /** 
     * Get the 'TaxInfo' element value.
     * 
     * @return value
     */
    public TaxInfo getTaxInfo() {
        return taxInfo;
    }

    /** 
     * Set the 'TaxInfo' element value.
     * 
     * @param taxInfo
     */
    public void setTaxInfo(TaxInfo taxInfo) {
        this.taxInfo = taxInfo;
    }

    /** 
     * Get the 'Address' element value.
     * 
     * @return value
     */
    public SearchAddressType getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value.
     * 
     * @param address
     */
    public void setAddress(SearchAddressType address) {
        this.address = address;
    }

    /** 
     * Get the 'CustLoyalty' element value. 
     ***OTA Based *** Customer Loyalty (Frequent
    					Flyer, Prefered Vendor etc.) Information
    				
     * 
     * @return value
     */
    public SearchCustLoyaltyType getCustLoyalty() {
        return custLoyalty;
    }

    /** 
     * Set the 'CustLoyalty' element value. 
     ***OTA Based *** Customer Loyalty (Frequent
    					Flyer, Prefered Vendor etc.) Information
    				
     * 
     * @param custLoyalty
     */
    public void setCustLoyalty(SearchCustLoyaltyType custLoyalty) {
        this.custLoyalty = custLoyalty;
    }

    /** 
     * Get the 'CustomerReferenceInfo' element value. 
     *** SABRE ADDED *** Third party system Reference
    					IDs for a profile
    				
     * 
     * @return value
     */
    public SearchCustomerReferenceInfoType getCustomerReferenceInfo() {
        return customerReferenceInfo;
    }

    /** 
     * Set the 'CustomerReferenceInfo' element value. 
     *** SABRE ADDED *** Third party system Reference
    					IDs for a profile
    				
     * 
     * @param customerReferenceInfo
     */
    public void setCustomerReferenceInfo(
            SearchCustomerReferenceInfoType customerReferenceInfo) {
        this.customerReferenceInfo = customerReferenceInfo;
    }

    /** 
     * Get the 'BusinessSystemIdentityInfo' element value. Business System Idenitity Info Search element
     * 
     * @return value
     */
    public SearchBusinessSystemIdenitityInfo getBusinessSystemIdentityInfo() {
        return businessSystemIdentityInfo;
    }

    /** 
     * Set the 'BusinessSystemIdentityInfo' element value. Business System Idenitity Info Search element
     * 
     * @param businessSystemIdentityInfo
     */
    public void setBusinessSystemIdentityInfo(
            SearchBusinessSystemIdenitityInfo businessSystemIdentityInfo) {
        this.businessSystemIdentityInfo = businessSystemIdentityInfo;
    }

    /** 
     * Get the 'AssociatedProfiles' element value. 
     *** SABRE ADDED *** Associated profiles
    				
     * 
     * @return value
     */
    public SearchAssociatedProfilesType getAssociatedProfiles() {
        return associatedProfiles;
    }

    /** 
     * Set the 'AssociatedProfiles' element value. 
     *** SABRE ADDED *** Associated profiles
    				
     * 
     * @param associatedProfiles
     */
    public void setAssociatedProfiles(
            SearchAssociatedProfilesType associatedProfiles) {
        this.associatedProfiles = associatedProfiles;
    }

    /** 
     * Get the 'SearchOperationType' attribute value. 
     *** SABRE ADDED *** Value AND or OR 
    			
     * 
     * @return value
     */
    public SearchOperationTypeInfo getSearchOperationType() {
        return searchOperationType;
    }

    /** 
     * Set the 'SearchOperationType' attribute value. 
     *** SABRE ADDED *** Value AND or OR 
    			
     * 
     * @param searchOperationType
     */
    public void setSearchOperationType(
            SearchOperationTypeInfo searchOperationType) {
        this.searchOperationType = searchOperationType;
    }

    /** 
     * Get the 'ExcludeDeletedProfiles' attribute value. 
    				If attribute is set to 'Y', profiles with 'deleted'
    				status will not be returned in Search Response.
    			
     * 
     * @return value
     */
    public YesNoType getExcludeDeletedProfiles() {
        return excludeDeletedProfiles;
    }

    /** 
     * Set the 'ExcludeDeletedProfiles' attribute value. 
    				If attribute is set to 'Y', profiles with 'deleted'
    				status will not be returned in Search Response.
    			
     * 
     * @param excludeDeletedProfiles
     */
    public void setExcludeDeletedProfiles(YesNoType excludeDeletedProfiles) {
        this.excludeDeletedProfiles = excludeDeletedProfiles;
    }

    /** 
     * Get the 'IncludeAdminProfiles' attribute value. 
    				If attribute is set to 'Y', profiles with sub type code CAD (admin) will be included in Search Response.
    			
     * 
     * @return value
     */
    public YesNoType getIncludeAdminProfiles() {
        return includeAdminProfiles;
    }

    /** 
     * Set the 'IncludeAdminProfiles' attribute value. 
    				If attribute is set to 'Y', profiles with sub type code CAD (admin) will be included in Search Response.
    			
     * 
     * @param includeAdminProfiles
     */
    public void setIncludeAdminProfiles(YesNoType includeAdminProfiles) {
        this.includeAdminProfiles = includeAdminProfiles;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:SearchTravelerInfoType" name="Traveler" minOccurs="0"/>
     *   &lt;xs:element type="ns:SearchTravelAgentInfoType" name="TravelAgent" minOccurs="0"/>
     *   &lt;xs:element type="ns:SearchTravelAgencyInfoType" name="TravelAgency" minOccurs="0"/>
     *   &lt;xs:element type="ns:SearchCorporationInfoType" name="Corporation" minOccurs="0"/>
     *   &lt;xs:element type="ns:SearchGroupInfoType" name="GroupProfile" minOccurs="0"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int TRAVELER_CHOICE = 0;
        private static final int TRAVEL_AGENT_CHOICE = 1;
        private static final int TRAVEL_AGENCY_CHOICE = 2;
        private static final int CORPORATION_CHOICE = 3;
        private static final int GROUP_PROFILE_CHOICE = 4;
        private SearchTravelerInfoType traveler;
        private SearchTravelAgentInfoType travelAgent;
        private SearchTravelAgencyInfoType travelAgency;
        private SearchCorporationInfoType corporation;
        private SearchGroupInfoType groupProfile;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Traveler is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTraveler() {
            return choiceSelect == TRAVELER_CHOICE;
        }

        /** 
         * Get the 'Traveler' element value.
         * 
         * @return value
         */
        public SearchTravelerInfoType getTraveler() {
            return traveler;
        }

        /** 
         * Set the 'Traveler' element value.
         * 
         * @param traveler
         */
        public void setTraveler(SearchTravelerInfoType traveler) {
            setChoiceSelect(TRAVELER_CHOICE);
            this.traveler = traveler;
        }

        /** 
         * Check if TravelAgent is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTravelAgent() {
            return choiceSelect == TRAVEL_AGENT_CHOICE;
        }

        /** 
         * Get the 'TravelAgent' element value.
         * 
         * @return value
         */
        public SearchTravelAgentInfoType getTravelAgent() {
            return travelAgent;
        }

        /** 
         * Set the 'TravelAgent' element value.
         * 
         * @param travelAgent
         */
        public void setTravelAgent(SearchTravelAgentInfoType travelAgent) {
            setChoiceSelect(TRAVEL_AGENT_CHOICE);
            this.travelAgent = travelAgent;
        }

        /** 
         * Check if TravelAgency is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTravelAgency() {
            return choiceSelect == TRAVEL_AGENCY_CHOICE;
        }

        /** 
         * Get the 'TravelAgency' element value.
         * 
         * @return value
         */
        public SearchTravelAgencyInfoType getTravelAgency() {
            return travelAgency;
        }

        /** 
         * Set the 'TravelAgency' element value.
         * 
         * @param travelAgency
         */
        public void setTravelAgency(SearchTravelAgencyInfoType travelAgency) {
            setChoiceSelect(TRAVEL_AGENCY_CHOICE);
            this.travelAgency = travelAgency;
        }

        /** 
         * Check if Corporation is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCorporation() {
            return choiceSelect == CORPORATION_CHOICE;
        }

        /** 
         * Get the 'Corporation' element value.
         * 
         * @return value
         */
        public SearchCorporationInfoType getCorporation() {
            return corporation;
        }

        /** 
         * Set the 'Corporation' element value.
         * 
         * @param corporation
         */
        public void setCorporation(SearchCorporationInfoType corporation) {
            setChoiceSelect(CORPORATION_CHOICE);
            this.corporation = corporation;
        }

        /** 
         * Check if GroupProfile is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifGroupProfile() {
            return choiceSelect == GROUP_PROFILE_CHOICE;
        }

        /** 
         * Get the 'GroupProfile' element value.
         * 
         * @return value
         */
        public SearchGroupInfoType getGroupProfile() {
            return groupProfile;
        }

        /** 
         * Set the 'GroupProfile' element value.
         * 
         * @param groupProfile
         */
        public void setGroupProfile(SearchGroupInfoType groupProfile) {
            setChoiceSelect(GROUP_PROFILE_CHOICE);
            this.groupProfile = groupProfile;
        }
    }
    /** 
     * *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="TaxID"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="TaxTypeCode"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TaxInfo implements Serializable
    {
        private String taxID;
        private String taxTypeCode;

        /** 
         * Get the 'TaxID' attribute value.  Tax ID 
         * 
         * @return value
         */
        public String getTaxID() {
            return taxID;
        }

        /** 
         * Set the 'TaxID' attribute value.  Tax ID 
         * 
         * @param taxID
         */
        public void setTaxID(String taxID) {
            this.taxID = taxID;
        }

        /** 
         * Get the 'TaxTypeCode' attribute value. Tax Type 
         * 
         * @return value
         */
        public String getTaxTypeCode() {
            return taxTypeCode;
        }

        /** 
         * Set the 'TaxTypeCode' attribute value. Tax Type 
         * 
         * @param taxTypeCode
         */
        public void setTaxTypeCode(String taxTypeCode) {
            this.taxTypeCode = taxTypeCode;
        }
    }
}
