
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileEventActionType">
 *   &lt;xs:attribute type="ns:EventActionOperationType" use="required" name="Type"/>
 *   &lt;xs:attribute type="xs:dateTime" use="required" name="Timestamp"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="PurgeTimestamp"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileEventActionType implements Serializable
{
    private EventActionOperationType type;
    private Date timestamp;
    private Date purgeTimestamp;

    /** 
     * Get the 'Type' attribute value.
     * 
     * @return value
     */
    public EventActionOperationType getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value.
     * 
     * @param type
     */
    public void setType(EventActionOperationType type) {
        this.type = type;
    }

    /** 
     * Get the 'Timestamp' attribute value. Date/time when action was performed.
     * 
     * @return value
     */
    public Date getTimestamp() {
        return timestamp;
    }

    /** 
     * Set the 'Timestamp' attribute value. Date/time when action was performed.
     * 
     * @param timestamp
     */
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    /** 
     * Get the 'PurgeTimestamp' attribute value. Indicates date when profile will be purged (physically deleted). Applies only to DELETE operation.		
    			
     * 
     * @return value
     */
    public Date getPurgeTimestamp() {
        return purgeTimestamp;
    }

    /** 
     * Set the 'PurgeTimestamp' attribute value. Indicates date when profile will be purged (physically deleted). Applies only to DELETE operation.		
    			
     * 
     * @param purgeTimestamp
     */
    public void setPurgeTimestamp(Date purgeTimestamp) {
        this.purgeTimestamp = purgeTimestamp;
    }
}
