
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileInfoType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:ProfileType" name="Profile"/>
 *     &lt;xs:element type="ns:PartialUpdatesType" name="PartialUpdates"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileInfoType implements Serializable
{
    private int choiceSelect = -1;
    private static final int PROFILE_CHOICE = 0;
    private static final int PARTIAL_UPDATES_CHOICE = 1;
    private ProfileType profile;
    private PartialUpdatesType partialUpdates;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Profile is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProfile() {
        return choiceSelect == PROFILE_CHOICE;
    }

    /** 
     * Get the 'Profile' element value.  *** OTA Based *** Complete Update of a Profile
    		
     * 
     * @return value
     */
    public ProfileType getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value.  *** OTA Based *** Complete Update of a Profile
    		
     * 
     * @param profile
     */
    public void setProfile(ProfileType profile) {
        setChoiceSelect(PROFILE_CHOICE);
        this.profile = profile;
    }

    /** 
     * Check if PartialUpdates is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPartialUpdates() {
        return choiceSelect == PARTIAL_UPDATES_CHOICE;
    }

    /** 
     * Get the 'PartialUpdates' element value. *** OTA Based *** Partial Update of Profile
     * 
     * @return value
     */
    public PartialUpdatesType getPartialUpdates() {
        return partialUpdates;
    }

    /** 
     * Set the 'PartialUpdates' element value. *** OTA Based *** Partial Update of Profile
     * 
     * @param partialUpdates
     */
    public void setPartialUpdates(PartialUpdatesType partialUpdates) {
        setChoiceSelect(PARTIAL_UPDATES_CHOICE);
        this.partialUpdates = partialUpdates;
    }
}
