
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Root element for Filter content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileToPNRFilterType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ProfileToPNRAssociatedFormatType" name="AssociatedFormats" minOccurs="0" maxOccurs="100"/>
 *     &lt;xs:element type="ns:ProfileToPNRFormatStringType" name="FormatString" minOccurs="0" maxOccurs="100"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="FilterID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FilterName"/>
 *   &lt;xs:attribute type="ns:FormatOrderingSequenceModeType" use="optional" name="FormatOrderingSequenceMode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileToPNRFilterType implements Serializable
{
    private List<ProfileToPNRAssociatedFormatType> associatedFormatList = new ArrayList<ProfileToPNRAssociatedFormatType>();
    private List<ProfileToPNRFormatStringType> formatStringList = new ArrayList<ProfileToPNRFormatStringType>();
    private String filterID;
    private String domainID;
    private String clientCode;
    private String clientContextCode;
    private String filterName;
    private FormatOrderingSequenceModeType formatOrderingSequenceMode;

    /** 
     * Get the list of 'AssociatedFormats' element items. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @return list
     */
    public List<ProfileToPNRAssociatedFormatType> getAssociatedFormatList() {
        return associatedFormatList;
    }

    /** 
     * Set the list of 'AssociatedFormats' element items. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @param list
     */
    public void setAssociatedFormatList(
            List<ProfileToPNRAssociatedFormatType> list) {
        associatedFormatList = list;
    }

    /** 
     * Get the list of 'FormatString' element items. *** SABRE ADDED *** Formats as Strings that needs to be moved direclty into PNR with out parsing 
     * 
     * @return list
     */
    public List<ProfileToPNRFormatStringType> getFormatStringList() {
        return formatStringList;
    }

    /** 
     * Set the list of 'FormatString' element items. *** SABRE ADDED *** Formats as Strings that needs to be moved direclty into PNR with out parsing 
     * 
     * @param list
     */
    public void setFormatStringList(List<ProfileToPNRFormatStringType> list) {
        formatStringList = list;
    }

    /** 
     * Get the 'FilterID' attribute value. *** SABRE ADDED *** ID of the Filter in the database
     * 
     * @return value
     */
    public String getFilterID() {
        return filterID;
    }

    /** 
     * Set the 'FilterID' attribute value. *** SABRE ADDED *** ID of the Filter in the database
     * 
     * @param filterID
     */
    public void setFilterID(String filterID) {
        this.filterID = filterID;
    }

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'FilterName' attribute value.
     * 
     * @return value
     */
    public String getFilterName() {
        return filterName;
    }

    /** 
     * Set the 'FilterName' attribute value.
     * 
     * @param filterName
     */
    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    /** 
     * Get the 'FormatOrderingSequenceMode' attribute value. Ordering mode for Formats of Main Profile and Associated Profiles
     * 
     * @return value
     */
    public FormatOrderingSequenceModeType getFormatOrderingSequenceMode() {
        return formatOrderingSequenceMode;
    }

    /** 
     * Set the 'FormatOrderingSequenceMode' attribute value. Ordering mode for Formats of Main Profile and Associated Profiles
     * 
     * @param formatOrderingSequenceMode
     */
    public void setFormatOrderingSequenceMode(
            FormatOrderingSequenceModeType formatOrderingSequenceMode) {
        this.formatOrderingSequenceMode = formatOrderingSequenceMode;
    }
}
