
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileToPNRProfileFilterType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ProfileToPNRFilterType" name="Filter" minOccurs="0"/>
 *     &lt;xs:element type="ns:FilterPathAssociatedProfilesType" name="AssociatedProfiles" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="UniqueID"/>
 *   &lt;xs:attribute type="ns:ProfileTypeInfo" use="optional" name="ProfileTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProfileName"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="PNRMoveOrderSeqNo"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="BlindMoveByProfName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ExcludeProfileTypes"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileToPNRProfileFilterType implements Serializable
{
    private ProfileToPNRFilterType filter;
    private FilterPathAssociatedProfilesType associatedProfiles;
    private String clientCode;
    private String clientContextCode;
    private String uniqueID;
    private ProfileTypeInfo profileTypeCode;
    private String profileName;
    private String domainID;
    private String PNRMoveOrderSeqNo;
    private YesNoType blindMoveByProfName;
    private String excludeProfileTypes;

    /** 
     * Get the 'Filter' element value. *** SABRE ADDED *** Information about structure of a Filter 
     * 
     * @return value
     */
    public ProfileToPNRFilterType getFilter() {
        return filter;
    }

    /** 
     * Set the 'Filter' element value. *** SABRE ADDED *** Information about structure of a Filter 
     * 
     * @param filter
     */
    public void setFilter(ProfileToPNRFilterType filter) {
        this.filter = filter;
    }

    /** 
     * Get the 'AssociatedProfiles' element value. If specified, the profile searched by name must have an associated profile matching this section. Applies only when BlindMoveByProfileName=Y
     * 
     * @return value
     */
    public FilterPathAssociatedProfilesType getAssociatedProfiles() {
        return associatedProfiles;
    }

    /** 
     * Set the 'AssociatedProfiles' element value. If specified, the profile searched by name must have an associated profile matching this section. Applies only when BlindMoveByProfileName=Y
     * 
     * @param associatedProfiles
     */
    public void setAssociatedProfiles(
            FilterPathAssociatedProfilesType associatedProfiles) {
        this.associatedProfiles = associatedProfiles;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'UniqueID' attribute value.
     * 
     * @return value
     */
    public String getUniqueID() {
        return uniqueID;
    }

    /** 
     * Set the 'UniqueID' attribute value.
     * 
     * @param uniqueID
     */
    public void setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    /** 
     * Get the 'ProfileTypeCode' attribute value. Profile Type - only required when profile is specified by ID (not used in Blind Move)
    			
     * 
     * @return value
     */
    public ProfileTypeInfo getProfileTypeCode() {
        return profileTypeCode;
    }

    /** 
     * Set the 'ProfileTypeCode' attribute value. Profile Type - only required when profile is specified by ID (not used in Blind Move)
    			
     * 
     * @param profileTypeCode
     */
    public void setProfileTypeCode(ProfileTypeInfo profileTypeCode) {
        this.profileTypeCode = profileTypeCode;
    }

    /** 
     * Get the 'ProfileName' attribute value.
     * 
     * @return value
     */
    public String getProfileName() {
        return profileName;
    }

    /** 
     * Set the 'ProfileName' attribute value.
     * 
     * @param profileName
     */
    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    /** 
     * Get the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
    	
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
    	
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'PNRMoveOrderSeqNo' attribute value. Indicates position of current Profile (together with associated profiles) among other Profiles in this FilterPath request
     * 
     * @return value
     */
    public String getPNRMoveOrderSeqNo() {
        return PNRMoveOrderSeqNo;
    }

    /** 
     * Set the 'PNRMoveOrderSeqNo' attribute value. Indicates position of current Profile (together with associated profiles) among other Profiles in this FilterPath request
     * 
     * @param PNRMoveOrderSeqNo
     */
    public void setPNRMoveOrderSeqNo(String PNRMoveOrderSeqNo) {
        this.PNRMoveOrderSeqNo = PNRMoveOrderSeqNo;
    }

    /** 
     * Get the 'BlindMoveByProfName' attribute value. When set to Y, profile to be moved is looked up by ProfileName and Associated Profile Name (if present), not by UniqueID
     * 
     * @return value
     */
    public YesNoType getBlindMoveByProfName() {
        return blindMoveByProfName;
    }

    /** 
     * Set the 'BlindMoveByProfName' attribute value. When set to Y, profile to be moved is looked up by ProfileName and Associated Profile Name (if present), not by UniqueID
     * 
     * @param blindMoveByProfName
     */
    public void setBlindMoveByProfName(YesNoType blindMoveByProfName) {
        this.blindMoveByProfName = blindMoveByProfName;
    }

    /** 
     * Get the 'ExcludeProfileTypes' attribute value. Profile types that will be excluded when searching for profile by name. Applies only when BlindMoveByProfileName=Y. Multiple types separated wth comma can be speciified.
     * 
     * @return value
     */
    public String getExcludeProfileTypes() {
        return excludeProfileTypes;
    }

    /** 
     * Set the 'ExcludeProfileTypes' attribute value. Profile types that will be excluded when searching for profile by name. Applies only when BlindMoveByProfileName=Y. Multiple types separated wth comma can be speciified.
     * 
     * @param excludeProfileTypes
     */
    public void setExcludeProfileTypes(String excludeProfileTypes) {
        this.excludeProfileTypes = excludeProfileTypes;
    }
}
