
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A placeholder in the schema to allow for additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileToPNR_TPA_Extensions_Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:RemarkType" name="Remark" minOccurs="0" maxOccurs="1000"/>
 *     &lt;xs:element type="ns:SSRType" name="SSR" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:OSIType" name="OSI" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:CustomerReferenceInfoType" name="CustomerReferenceInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:BusinessSystemIdentityInfoType" name="BusinessSystemIdentityInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:ProfileToPNR_AssociatedProfilesType" name="AssociatedProfiles" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:DiscountsType" name="Discounts" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:CustomDefinedDataType" name="CustomDefinedData" minOccurs="0" maxOccurs="500"/>
 *     &lt;xs:element type="ns:TaxInfoType" name="TaxInfo" minOccurs="0" maxOccurs="200"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileToPNRTPAExtensionsType implements Serializable
{
    private List<RemarkType> remarkList = new ArrayList<RemarkType>();
    private List<SSRType> SSRList = new ArrayList<SSRType>();
    private List<OSIType> OSIList = new ArrayList<OSIType>();
    private List<CustomerReferenceInfoType> customerReferenceInfoList = new ArrayList<CustomerReferenceInfoType>();
    private List<BusinessSystemIdentityInfoType> businessSystemIdentityInfoList = new ArrayList<BusinessSystemIdentityInfoType>();
    private List<ProfileToPNRAssociatedProfilesType> associatedProfileList = new ArrayList<ProfileToPNRAssociatedProfilesType>();
    private List<DiscountsType> discountList = new ArrayList<DiscountsType>();
    private List<CustomDefinedDataType> customDefinedDataList = new ArrayList<CustomDefinedDataType>();
    private List<TaxInfoType> taxInfoList = new ArrayList<TaxInfoType>();

    /** 
     * Get the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @return list
     */
    public List<RemarkType> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @param list
     */
    public void setRemarkList(List<RemarkType> list) {
        remarkList = list;
    }

    /** 
     * Get the list of 'SSR' element items. *** SABRE ADDED *** Special service requets for a profile
     * 
     * @return list
     */
    public List<SSRType> getSSRList() {
        return SSRList;
    }

    /** 
     * Set the list of 'SSR' element items. *** SABRE ADDED *** Special service requets for a profile
     * 
     * @param list
     */
    public void setSSRList(List<SSRType> list) {
        SSRList = list;
    }

    /** 
     * Get the list of 'OSI' element items. *** SABRE ADDED *** Other Service Info for a profile
     * 
     * @return list
     */
    public List<OSIType> getOSIList() {
        return OSIList;
    }

    /** 
     * Set the list of 'OSI' element items. *** SABRE ADDED *** Other Service Info for a profile
     * 
     * @param list
     */
    public void setOSIList(List<OSIType> list) {
        OSIList = list;
    }

    /** 
     * Get the list of 'CustomerReferenceInfo' element items. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return list
     */
    public List<CustomerReferenceInfoType> getCustomerReferenceInfoList() {
        return customerReferenceInfoList;
    }

    /** 
     * Set the list of 'CustomerReferenceInfo' element items. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param list
     */
    public void setCustomerReferenceInfoList(
            List<CustomerReferenceInfoType> list) {
        customerReferenceInfoList = list;
    }

    /** 
     * Get the list of 'BusinessSystemIdentityInfo' element items. *** SABRE ADDED *** Traveler BackOffice System Information data 
     * 
     * @return list
     */
    public List<BusinessSystemIdentityInfoType> getBusinessSystemIdentityInfoList() {
        return businessSystemIdentityInfoList;
    }

    /** 
     * Set the list of 'BusinessSystemIdentityInfo' element items. *** SABRE ADDED *** Traveler BackOffice System Information data 
     * 
     * @param list
     */
    public void setBusinessSystemIdentityInfoList(
            List<BusinessSystemIdentityInfoType> list) {
        businessSystemIdentityInfoList = list;
    }

    /** 
     * Get the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Associated profiles
     * 
     * @return list
     */
    public List<ProfileToPNRAssociatedProfilesType> getAssociatedProfileList() {
        return associatedProfileList;
    }

    /** 
     * Set the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Associated profiles
     * 
     * @param list
     */
    public void setAssociatedProfileList(
            List<ProfileToPNRAssociatedProfilesType> list) {
        associatedProfileList = list;
    }

    /** 
     * Get the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @return list
     */
    public List<DiscountsType> getDiscountList() {
        return discountList;
    }

    /** 
     * Set the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @param list
     */
    public void setDiscountList(List<DiscountsType> list) {
        discountList = list;
    }

    /** 
     * Get the list of 'CustomDefinedData' element items. *** SABRE ADDED *** Customer Defined Data
     * 
     * @return list
     */
    public List<CustomDefinedDataType> getCustomDefinedDataList() {
        return customDefinedDataList;
    }

    /** 
     * Set the list of 'CustomDefinedData' element items. *** SABRE ADDED *** Customer Defined Data
     * 
     * @param list
     */
    public void setCustomDefinedDataList(List<CustomDefinedDataType> list) {
        customDefinedDataList = list;
    }

    /** 
     * Get the list of 'TaxInfo' element items. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @return list
     */
    public List<TaxInfoType> getTaxInfoList() {
        return taxInfoList;
    }

    /** 
     * Set the list of 'TaxInfo' element items. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @param list
     */
    public void setTaxInfoList(List<TaxInfoType> list) {
        taxInfoList = list;
    }
}
