
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Added by Sabre
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileToPNR_TPAIdentityType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ProfileSubTypeType" name="ProfileSubType" minOccurs="0" maxOccurs="5"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="UniqueID"/>
 *   &lt;xs:attribute type="ns:ProfileTypeInfo" use="required" name="ProfileTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProfileName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProfileDescription"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="ns:StatusType" use="optional" default="AC" name="ProfileStatusCode"/>
 *   &lt;xs:attribute type="xs:string" name="PNRMoveOrderSeqNo"/>
 *   &lt;xs:attribute type="ns:FormatOrderingSequenceModeType" use="optional" name="FormatOrderingSequenceMode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileToPNRTPAIdentityType implements Serializable
{
    private List<ProfileSubTypeType> profileSubTypeList = new ArrayList<ProfileSubTypeType>();
    private String clientCode;
    private String clientContextCode;
    private String uniqueID;
    private ProfileTypeInfo profileTypeCode;
    private String profileName;
    private String profileDescription;
    private String domainID;
    private StatusType profileStatusCode;
    private String PNRMoveOrderSeqNo;
    private FormatOrderingSequenceModeType formatOrderingSequenceMode;

    /** 
     * Get the list of 'ProfileSubType' element items.
     * 
     * @return list
     */
    public List<ProfileSubTypeType> getProfileSubTypeList() {
        return profileSubTypeList;
    }

    /** 
     * Set the list of 'ProfileSubType' element items.
     * 
     * @param list
     */
    public void setProfileSubTypeList(List<ProfileSubTypeType> list) {
        profileSubTypeList = list;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'UniqueID' attribute value.
     * 
     * @return value
     */
    public String getUniqueID() {
        return uniqueID;
    }

    /** 
     * Set the 'UniqueID' attribute value.
     * 
     * @param uniqueID
     */
    public void setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    /** 
     * Get the 'ProfileTypeCode' attribute value.
     * 
     * @return value
     */
    public ProfileTypeInfo getProfileTypeCode() {
        return profileTypeCode;
    }

    /** 
     * Set the 'ProfileTypeCode' attribute value.
     * 
     * @param profileTypeCode
     */
    public void setProfileTypeCode(ProfileTypeInfo profileTypeCode) {
        this.profileTypeCode = profileTypeCode;
    }

    /** 
     * Get the 'ProfileName' attribute value.
     * 
     * @return value
     */
    public String getProfileName() {
        return profileName;
    }

    /** 
     * Set the 'ProfileName' attribute value.
     * 
     * @param profileName
     */
    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    /** 
     * Get the 'ProfileDescription' attribute value. Description of a profile if needed 
     * 
     * @return value
     */
    public String getProfileDescription() {
        return profileDescription;
    }

    /** 
     * Set the 'ProfileDescription' attribute value. Description of a profile if needed 
     * 
     * @param profileDescription
     */
    public void setProfileDescription(String profileDescription) {
        this.profileDescription = profileDescription;
    }

    /** 
     * Get the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
    	
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
    	
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'ProfileStatusCode' attribute value.
     * 
     * @return value
     */
    public StatusType getProfileStatusCode() {
        return profileStatusCode;
    }

    /** 
     * Set the 'ProfileStatusCode' attribute value.
     * 
     * @param profileStatusCode
     */
    public void setProfileStatusCode(StatusType profileStatusCode) {
        this.profileStatusCode = profileStatusCode;
    }

    /** 
     * Get the 'PNRMoveOrderSeqNo' attribute value.
     * 
     * @return value
     */
    public String getPNRMoveOrderSeqNo() {
        return PNRMoveOrderSeqNo;
    }

    /** 
     * Set the 'PNRMoveOrderSeqNo' attribute value.
     * 
     * @param PNRMoveOrderSeqNo
     */
    public void setPNRMoveOrderSeqNo(String PNRMoveOrderSeqNo) {
        this.PNRMoveOrderSeqNo = PNRMoveOrderSeqNo;
    }

    /** 
     * Get the 'FormatOrderingSequenceMode' attribute value. Ordering mode for Formats of Associated Profiles (not of main Profile)
     * 
     * @return value
     */
    public FormatOrderingSequenceModeType getFormatOrderingSequenceMode() {
        return formatOrderingSequenceMode;
    }

    /** 
     * Set the 'FormatOrderingSequenceMode' attribute value. Ordering mode for Formats of Associated Profiles (not of main Profile)
     * 
     * @param formatOrderingSequenceMode
     */
    public void setFormatOrderingSequenceMode(
            FormatOrderingSequenceModeType formatOrderingSequenceMode) {
        this.formatOrderingSequenceMode = formatOrderingSequenceMode;
    }
}
