
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Individual Travel Arranger
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileToPNRTravelAgentProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AgentNameType" name="AgentName" minOccurs="0" maxOccurs="50"/>
 *     &lt;xs:element type="ns:AgentInfoType" name="AgentInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:RelatedIndividualType" name="AgentRelatedIndividuals" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:AgentGDSIdentityType" name="AgentGDSIdentity" minOccurs="0" maxOccurs="10"/>
 *     &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:TelephoneType" name="Telephone" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:EmailType" name="Email" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:PaymentFormType" name="PaymentForm" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:ContactType" name="EmergencyContactPerson" minOccurs="0" maxOccurs="10"/>
 *     &lt;xs:element type="ns:DocumentType" name="Document" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:CustLoyaltyType" name="CustLoyalty" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:EmploymentInfoType" name="EmploymentInfo" minOccurs="0" maxOccurs="25"/>
 *     &lt;xs:element type="ns:GDSType" name="GDS" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:RemarkType" name="Remark" minOccurs="0" maxOccurs="1000"/>
 *     &lt;xs:element type="ns:CustomerReferenceInfoType" name="CustomerReferenceInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:BusinessSystemIdentityInfoType" name="BusinessSystemIdentityInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:ProfileToPNR_AssociatedProfilesType" name="AssociatedProfiles" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:DiscountsType" name="Discounts" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:CustomDefinedDataType" name="CustomDefinedData" minOccurs="0" maxOccurs="500"/>
 *     &lt;xs:element type="ns:PrefCollectionsType" name="PrefCollections" minOccurs="0"/>
 *     &lt;xs:element type="ns:QueueAssignmentsType" name="QueueAssignments" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:CommissionsType" name="Commissions" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:IncentivesType" name="Incentives" minOccurs="0" maxOccurs="200"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileToPNRTravelAgentProfileType implements Serializable
{
    private List<AgentNameType> agentNameList = new ArrayList<AgentNameType>();
    private AgentInfoType agentInfo;
    private List<RelatedIndividualType> agentRelatedIndividualList = new ArrayList<RelatedIndividualType>();
    private List<AgentGDSIdentityType> agentGDSIdentityList = new ArrayList<AgentGDSIdentityType>();
    private List<AddressType> addressList = new ArrayList<AddressType>();
    private List<TelephoneType> telephoneList = new ArrayList<TelephoneType>();
    private List<EmailType> emailList = new ArrayList<EmailType>();
    private List<PaymentFormType> paymentFormList = new ArrayList<PaymentFormType>();
    private List<ContactType> emergencyContactPersonList = new ArrayList<ContactType>();
    private List<DocumentType> documentList = new ArrayList<DocumentType>();
    private List<CustLoyaltyType> custLoyaltyList = new ArrayList<CustLoyaltyType>();
    private List<EmploymentInfoType> employmentInfoList = new ArrayList<EmploymentInfoType>();
    private List<GDSType> GDSList = new ArrayList<GDSType>();
    private List<RemarkType> remarkList = new ArrayList<RemarkType>();
    private List<CustomerReferenceInfoType> customerReferenceInfoList = new ArrayList<CustomerReferenceInfoType>();
    private List<BusinessSystemIdentityInfoType> businessSystemIdentityInfoList = new ArrayList<BusinessSystemIdentityInfoType>();
    private List<ProfileToPNRAssociatedProfilesType> associatedProfileList = new ArrayList<ProfileToPNRAssociatedProfilesType>();
    private List<DiscountsType> discountList = new ArrayList<DiscountsType>();
    private List<CustomDefinedDataType> customDefinedDataList = new ArrayList<CustomDefinedDataType>();
    private PrefCollectionsType prefCollections;
    private List<QueueAssignmentsType> queueAssignmentList = new ArrayList<QueueAssignmentsType>();
    private List<CommissionsType> commissionList = new ArrayList<CommissionsType>();
    private List<IncentivesType> incentiveList = new ArrayList<IncentivesType>();

    /** 
     * Get the list of 'AgentName' element items. ***SABRE ADDED *** Agent Name Information 
     * 
     * @return list
     */
    public List<AgentNameType> getAgentNameList() {
        return agentNameList;
    }

    /** 
     * Set the list of 'AgentName' element items. ***SABRE ADDED *** Agent Name Information 
     * 
     * @param list
     */
    public void setAgentNameList(List<AgentNameType> list) {
        agentNameList = list;
    }

    /** 
     * Get the 'AgentInfo' element value. *** SABRE ADDED *** Agenct Information data 
     * 
     * @return value
     */
    public AgentInfoType getAgentInfo() {
        return agentInfo;
    }

    /** 
     * Set the 'AgentInfo' element value. *** SABRE ADDED *** Agenct Information data 
     * 
     * @param agentInfo
     */
    public void setAgentInfo(AgentInfoType agentInfo) {
        this.agentInfo = agentInfo;
    }

    /** 
     * Get the list of 'AgentRelatedIndividuals' element items. ***OTA Based *** Agent Related Names Information 
     * 
     * @return list
     */
    public List<RelatedIndividualType> getAgentRelatedIndividualList() {
        return agentRelatedIndividualList;
    }

    /** 
     * Set the list of 'AgentRelatedIndividuals' element items. ***OTA Based *** Agent Related Names Information 
     * 
     * @param list
     */
    public void setAgentRelatedIndividualList(List<RelatedIndividualType> list) {
        agentRelatedIndividualList = list;
    }

    /** 
     * Get the list of 'AgentGDSIdentity' element items. ***OTA Based *** Agent GDS identity information  
     * 
     * @return list
     */
    public List<AgentGDSIdentityType> getAgentGDSIdentityList() {
        return agentGDSIdentityList;
    }

    /** 
     * Set the list of 'AgentGDSIdentity' element items. ***OTA Based *** Agent GDS identity information  
     * 
     * @param list
     */
    public void setAgentGDSIdentityList(List<AgentGDSIdentityType> list) {
        agentGDSIdentityList = list;
    }

    /** 
     * Get the list of 'Address' element items. ***OTA Based *** Address Information 
     * 
     * @return list
     */
    public List<AddressType> getAddressList() {
        return addressList;
    }

    /** 
     * Set the list of 'Address' element items. ***OTA Based *** Address Information 
     * 
     * @param list
     */
    public void setAddressList(List<AddressType> list) {
        addressList = list;
    }

    /** 
     * Get the list of 'Telephone' element items. ***OTA Based *** Telephone Information 
     * 
     * @return list
     */
    public List<TelephoneType> getTelephoneList() {
        return telephoneList;
    }

    /** 
     * Set the list of 'Telephone' element items. ***OTA Based *** Telephone Information 
     * 
     * @param list
     */
    public void setTelephoneList(List<TelephoneType> list) {
        telephoneList = list;
    }

    /** 
     * Get the list of 'Email' element items. ***OTA Based *** Email Information 
     * 
     * @return list
     */
    public List<EmailType> getEmailList() {
        return emailList;
    }

    /** 
     * Set the list of 'Email' element items. ***OTA Based *** Email Information 
     * 
     * @param list
     */
    public void setEmailList(List<EmailType> list) {
        emailList = list;
    }

    /** 
     * Get the list of 'PaymentForm' element items. *** SABRE ADDED*** Payment Information 
     * 
     * @return list
     */
    public List<PaymentFormType> getPaymentFormList() {
        return paymentFormList;
    }

    /** 
     * Set the list of 'PaymentForm' element items. *** SABRE ADDED*** Payment Information 
     * 
     * @param list
     */
    public void setPaymentFormList(List<PaymentFormType> list) {
        paymentFormList = list;
    }

    /** 
     * Get the list of 'EmergencyContactPerson' element items. ***OTA Based *** Emergency Contact Person Information 
     * 
     * @return list
     */
    public List<ContactType> getEmergencyContactPersonList() {
        return emergencyContactPersonList;
    }

    /** 
     * Set the list of 'EmergencyContactPerson' element items. ***OTA Based *** Emergency Contact Person Information 
     * 
     * @param list
     */
    public void setEmergencyContactPersonList(List<ContactType> list) {
        emergencyContactPersonList = list;
    }

    /** 
     * Get the list of 'Document' element items. ***OTA Based *** Document Information 
     * 
     * @return list
     */
    public List<DocumentType> getDocumentList() {
        return documentList;
    }

    /** 
     * Set the list of 'Document' element items. ***OTA Based *** Document Information 
     * 
     * @param list
     */
    public void setDocumentList(List<DocumentType> list) {
        documentList = list;
    }

    /** 
     * Get the list of 'CustLoyalty' element items. ***OTA Based *** Customer Loyalty (Frequent Flyer, Prefered Vendor etc.) Information 
     * 
     * @return list
     */
    public List<CustLoyaltyType> getCustLoyaltyList() {
        return custLoyaltyList;
    }

    /** 
     * Set the list of 'CustLoyalty' element items. ***OTA Based *** Customer Loyalty (Frequent Flyer, Prefered Vendor etc.) Information 
     * 
     * @param list
     */
    public void setCustLoyaltyList(List<CustLoyaltyType> list) {
        custLoyaltyList = list;
    }

    /** 
     * Get the list of 'EmploymentInfo' element items. *** Sabre Added *** EmploymentInfo elements and attributes, per Trading Partner Agreement (TPA)							
     * 
     * @return list
     */
    public List<EmploymentInfoType> getEmploymentInfoList() {
        return employmentInfoList;
    }

    /** 
     * Set the list of 'EmploymentInfo' element items. *** Sabre Added *** EmploymentInfo elements and attributes, per Trading Partner Agreement (TPA)							
     * 
     * @param list
     */
    public void setEmploymentInfoList(List<EmploymentInfoType> list) {
        employmentInfoList = list;
    }

    /** 
     * Get the list of 'GDS' element items. *** SABRE ADDED *** GDS data associated with an agent
     * 
     * @return list
     */
    public List<GDSType> getGDSList() {
        return GDSList;
    }

    /** 
     * Set the list of 'GDS' element items. *** SABRE ADDED *** GDS data associated with an agent
     * 
     * @param list
     */
    public void setGDSList(List<GDSType> list) {
        GDSList = list;
    }

    /** 
     * Get the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @return list
     */
    public List<RemarkType> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items. *** SABRE ADDED *** Remarks of a profile
     * 
     * @param list
     */
    public void setRemarkList(List<RemarkType> list) {
        remarkList = list;
    }

    /** 
     * Get the list of 'CustomerReferenceInfo' element items. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return list
     */
    public List<CustomerReferenceInfoType> getCustomerReferenceInfoList() {
        return customerReferenceInfoList;
    }

    /** 
     * Set the list of 'CustomerReferenceInfo' element items. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param list
     */
    public void setCustomerReferenceInfoList(
            List<CustomerReferenceInfoType> list) {
        customerReferenceInfoList = list;
    }

    /** 
     * Get the list of 'BusinessSystemIdentityInfo' element items. *** SABRE ADDED *** Agenct BackOffice System Information data 
     * 
     * @return list
     */
    public List<BusinessSystemIdentityInfoType> getBusinessSystemIdentityInfoList() {
        return businessSystemIdentityInfoList;
    }

    /** 
     * Set the list of 'BusinessSystemIdentityInfo' element items. *** SABRE ADDED *** Agenct BackOffice System Information data 
     * 
     * @param list
     */
    public void setBusinessSystemIdentityInfoList(
            List<BusinessSystemIdentityInfoType> list) {
        businessSystemIdentityInfoList = list;
    }

    /** 
     * Get the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Associated profiles
     * 
     * @return list
     */
    public List<ProfileToPNRAssociatedProfilesType> getAssociatedProfileList() {
        return associatedProfileList;
    }

    /** 
     * Set the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** (For Profiles Only --Templates/Filters should not use this Subject area) Associated profiles
     * 
     * @param list
     */
    public void setAssociatedProfileList(
            List<ProfileToPNRAssociatedProfilesType> list) {
        associatedProfileList = list;
    }

    /** 
     * Get the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @return list
     */
    public List<DiscountsType> getDiscountList() {
        return discountList;
    }

    /** 
     * Set the list of 'Discounts' element items. *** SABRE ADDED *** Discount Associated to a  profile
     * 
     * @param list
     */
    public void setDiscountList(List<DiscountsType> list) {
        discountList = list;
    }

    /** 
     * Get the list of 'CustomDefinedData' element items. *** SABRE ADDED *** Customer Defined Data
     * 
     * @return list
     */
    public List<CustomDefinedDataType> getCustomDefinedDataList() {
        return customDefinedDataList;
    }

    /** 
     * Set the list of 'CustomDefinedData' element items. *** SABRE ADDED *** Customer Defined Data
     * 
     * @param list
     */
    public void setCustomDefinedDataList(List<CustomDefinedDataType> list) {
        customDefinedDataList = list;
    }

    /** 
     * Get the 'PrefCollections' element value. ***OTA Based*** Preferences of a Profile 
     * 
     * @return value
     */
    public PrefCollectionsType getPrefCollections() {
        return prefCollections;
    }

    /** 
     * Set the 'PrefCollections' element value. ***OTA Based*** Preferences of a Profile 
     * 
     * @param prefCollections
     */
    public void setPrefCollections(PrefCollectionsType prefCollections) {
        this.prefCollections = prefCollections;
    }

    /** 
     * Get the list of 'QueueAssignments' element items. *** SABRE ADDED *** Queue Assignments
     * 
     * @return list
     */
    public List<QueueAssignmentsType> getQueueAssignmentList() {
        return queueAssignmentList;
    }

    /** 
     * Set the list of 'QueueAssignments' element items. *** SABRE ADDED *** Queue Assignments
     * 
     * @param list
     */
    public void setQueueAssignmentList(List<QueueAssignmentsType> list) {
        queueAssignmentList = list;
    }

    /** 
     * Get the list of 'Commissions' element items. *** SABRE ADDED *** Commissions
     * 
     * @return list
     */
    public List<CommissionsType> getCommissionList() {
        return commissionList;
    }

    /** 
     * Set the list of 'Commissions' element items. *** SABRE ADDED *** Commissions
     * 
     * @param list
     */
    public void setCommissionList(List<CommissionsType> list) {
        commissionList = list;
    }

    /** 
     * Get the list of 'Incentives' element items. *** SABRE ADDED *** Incentives  
     * 
     * @return list
     */
    public List<IncentivesType> getIncentiveList() {
        return incentiveList;
    }

    /** 
     * Set the list of 'Incentives' element items. *** SABRE ADDED *** Incentives  
     * 
     * @param list
     */
    public void setIncentiveList(List<IncentivesType> list) {
        incentiveList = list;
    }
}
