
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Root element for profile content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TPAIdentityType" name="TPA_Identity"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *     &lt;xs:element type="ns:IgnoreSubjectAreaType" name="IgnoreSubjectArea" minOccurs="0"/>
 *     &lt;xs:element type="ns:ProfileAssociationType" name="Association" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:dateTime" use="required" name="CreateDateTime"/>
 *   &lt;xs:attribute type="xs:dateTime" use="required" name="UpdateDateTime"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PrimaryLanguageIDCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileType implements Serializable
{
    private TPAIdentityType TPAIdentity;
    private Choice choice;
    private IgnoreSubjectAreaType ignoreSubjectArea;
    private ProfileAssociationType association;
    private Date createDateTime;
    private Date updateDateTime;
    private String primaryLanguageIDCode;

    /** 
     * Get the 'TPA_Identity' element value. ***SABRE ADDED*** To hold Identity information of a profile
     * 
     * @return value
     */
    public TPAIdentityType getTPAIdentity() {
        return TPAIdentity;
    }

    /** 
     * Set the 'TPA_Identity' element value. ***SABRE ADDED*** To hold Identity information of a profile
     * 
     * @param TPAIdentity
     */
    public void setTPAIdentity(TPAIdentityType TPAIdentity) {
        this.TPAIdentity = TPAIdentity;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'IgnoreSubjectArea' element value. ***SABRE ADDED*** Determines what Subject areas can be loaded along with the webservice operation 
     * 
     * @return value
     */
    public IgnoreSubjectAreaType getIgnoreSubjectArea() {
        return ignoreSubjectArea;
    }

    /** 
     * Set the 'IgnoreSubjectArea' element value. ***SABRE ADDED*** Determines what Subject areas can be loaded along with the webservice operation 
     * 
     * @param ignoreSubjectArea
     */
    public void setIgnoreSubjectArea(IgnoreSubjectAreaType ignoreSubjectArea) {
        this.ignoreSubjectArea = ignoreSubjectArea;
    }

    /** 
     * Get the 'Association' element value. ***SABRE ADDED*** To hold associated data identity information
     * 
     * @return value
     */
    public ProfileAssociationType getAssociation() {
        return association;
    }

    /** 
     * Set the 'Association' element value. ***SABRE ADDED*** To hold associated data identity information
     * 
     * @param association
     */
    public void setAssociation(ProfileAssociationType association) {
        this.association = association;
    }

    /** 
     * Get the 'CreateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @return value
     */
    public Date getCreateDateTime() {
        return createDateTime;
    }

    /** 
     * Set the 'CreateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @param createDateTime
     */
    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    /** 
     * Get the 'UpdateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @return value
     */
    public Date getUpdateDateTime() {
        return updateDateTime;
    }

    /** 
     * Set the 'UpdateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @param updateDateTime
     */
    public void setUpdateDateTime(Date updateDateTime) {
        this.updateDateTime = updateDateTime;
    }

    /** 
     * Get the 'PrimaryLanguageIDCode' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @return value
     */
    public String getPrimaryLanguageIDCode() {
        return primaryLanguageIDCode;
    }

    /** 
     * Set the 'PrimaryLanguageIDCode' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @param primaryLanguageIDCode
     */
    public void setPrimaryLanguageIDCode(String primaryLanguageIDCode) {
        this.primaryLanguageIDCode = primaryLanguageIDCode;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:TravelerProfileType" name="Traveler" minOccurs="0"/>
     *   &lt;xs:element type="ns:TravelAgencyProfileType" name="TravelAgency" minOccurs="0">
     *     &lt;xs:unique name="travelAgencyGDSUniqueness">
     *       &lt;xs:selector xpath="./p3:GDS"/>
     *       &lt;xs:field xpath="@GDSCode"/>
     *     &lt;/xs:unique>
     *     &lt;xs:unique name="travelAgencyCustomDefinedValuesNameUniqueness">
     *       &lt;xs:selector xpath="./p3:CustomDefinedValues"/>
     *       &lt;xs:field xpath="@Name"/>
     *     &lt;/xs:unique>
     *   &lt;/xs:element>
     *   &lt;xs:element type="ns:TravelAgentProfileType" name="TravelAgent" minOccurs="0">
     *     &lt;xs:unique name="travelAgentGDSUniqueness">
     *       &lt;xs:selector xpath="./p3:GDS"/>
     *       &lt;xs:field xpath="@GDSCode"/>
     *     &lt;/xs:unique>
     *     &lt;xs:unique name="travelAgentCustomDefinedValuesNameUniqueness">
     *       &lt;xs:selector xpath="./p3:CustomDefinedValues"/>
     *       &lt;xs:field xpath="@Name"/>
     *     &lt;/xs:unique>
     *   &lt;/xs:element>
     *   &lt;xs:element type="ns:CorporateProfileType" name="Corporation" minOccurs="0">
     *     &lt;xs:unique name="corporateGDSUniqueness">
     *       &lt;xs:selector xpath="./p3:GDS"/>
     *       &lt;xs:field xpath="@GDSCode"/>
     *     &lt;/xs:unique>
     *     &lt;xs:unique name="corporationCustomDefinedValuesNameUniqueness">
     *       &lt;xs:selector xpath="./p3:CustomDefinedValues"/>
     *       &lt;xs:field xpath="@Name"/>
     *     &lt;/xs:unique>
     *   &lt;/xs:element>
     *   &lt;xs:element type="ns:OperationalProfileType" name="OperationalProfile" minOccurs="0">
     *     &lt;xs:unique name="operationalCustomDefinedValuesNameUniqueness">
     *       &lt;xs:selector xpath="./p3:CustomDefinedValues"/>
     *       &lt;xs:field xpath="@Name"/>
     *     &lt;/xs:unique>
     *   &lt;/xs:element>
     *   &lt;xs:element type="ns:AllianceProfileType" name="AllianceProfile" minOccurs="0"/>
     *   &lt;xs:element type="ns:GroupProfileType" name="GroupProfile" minOccurs="0">
     *     &lt;xs:unique name="groupProfileGDSUniqueness">
     *       &lt;xs:selector xpath="./p3:GDS"/>
     *       &lt;xs:field xpath="@GDSCode"/>
     *     &lt;/xs:unique>
     *     &lt;xs:unique name="groupProfileCustomDefinedValuesNameUniqueness">
     *       &lt;xs:selector xpath="./p3:CustomDefinedValues"/>
     *       &lt;xs:field xpath="@Name"/>
     *     &lt;/xs:unique>
     *   &lt;/xs:element>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int TRAVELER_CHOICE = 0;
        private static final int TRAVEL_AGENCY_CHOICE = 1;
        private static final int TRAVEL_AGENT_CHOICE = 2;
        private static final int CORPORATION_CHOICE = 3;
        private static final int OPERATIONAL_PROFILE_CHOICE = 4;
        private static final int ALLIANCE_PROFILE_CHOICE = 5;
        private static final int GROUP_PROFILE_CHOICE = 6;
        private TravelerProfileType traveler;
        private TravelAgencyProfileType travelAgency;
        private TravelAgentProfileType travelAgent;
        private CorporateProfileType corporation;
        private OperationalProfileType operationalProfile;
        private AllianceProfileType allianceProfile;
        private GroupProfileType groupProfile;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Traveler is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTraveler() {
            return choiceSelect == TRAVELER_CHOICE;
        }

        /** 
         * Get the 'Traveler' element value. ***SABRE ADDED*** To hold Traveler Profile Information
         * 
         * @return value
         */
        public TravelerProfileType getTraveler() {
            return traveler;
        }

        /** 
         * Set the 'Traveler' element value. ***SABRE ADDED*** To hold Traveler Profile Information
         * 
         * @param traveler
         */
        public void setTraveler(TravelerProfileType traveler) {
            setChoiceSelect(TRAVELER_CHOICE);
            this.traveler = traveler;
        }

        /** 
         * Check if TravelAgency is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTravelAgency() {
            return choiceSelect == TRAVEL_AGENCY_CHOICE;
        }

        /** 
         * Get the 'TravelAgency' element value. ***SABRE ADDED*** To hold Travel Agency Profile 
         * 
         * @return value
         */
        public TravelAgencyProfileType getTravelAgency() {
            return travelAgency;
        }

        /** 
         * Set the 'TravelAgency' element value. ***SABRE ADDED*** To hold Travel Agency Profile 
         * 
         * @param travelAgency
         */
        public void setTravelAgency(TravelAgencyProfileType travelAgency) {
            setChoiceSelect(TRAVEL_AGENCY_CHOICE);
            this.travelAgency = travelAgency;
        }

        /** 
         * Check if TravelAgent is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTravelAgent() {
            return choiceSelect == TRAVEL_AGENT_CHOICE;
        }

        /** 
         * Get the 'TravelAgent' element value. ***SABRE ADDED*** To hold Travel Agent Profile 
         * 
         * @return value
         */
        public TravelAgentProfileType getTravelAgent() {
            return travelAgent;
        }

        /** 
         * Set the 'TravelAgent' element value. ***SABRE ADDED*** To hold Travel Agent Profile 
         * 
         * @param travelAgent
         */
        public void setTravelAgent(TravelAgentProfileType travelAgent) {
            setChoiceSelect(TRAVEL_AGENT_CHOICE);
            this.travelAgent = travelAgent;
        }

        /** 
         * Check if Corporation is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCorporation() {
            return choiceSelect == CORPORATION_CHOICE;
        }

        /** 
         * Get the 'Corporation' element value. ***SABRE ADDED*** To hold Corporation Profile 
         * 
         * @return value
         */
        public CorporateProfileType getCorporation() {
            return corporation;
        }

        /** 
         * Set the 'Corporation' element value. ***SABRE ADDED*** To hold Corporation Profile 
         * 
         * @param corporation
         */
        public void setCorporation(CorporateProfileType corporation) {
            setChoiceSelect(CORPORATION_CHOICE);
            this.corporation = corporation;
        }

        /** 
         * Check if OperationalProfile is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOperationalProfile() {
            return choiceSelect == OPERATIONAL_PROFILE_CHOICE;
        }

        /** 
         * Get the 'OperationalProfile' element value. ***SABRE ADDED*** To hold Operational Profiles data 
         * 
         * @return value
         */
        public OperationalProfileType getOperationalProfile() {
            return operationalProfile;
        }

        /** 
         * Set the 'OperationalProfile' element value. ***SABRE ADDED*** To hold Operational Profiles data 
         * 
         * @param operationalProfile
         */
        public void setOperationalProfile(
                OperationalProfileType operationalProfile) {
            setChoiceSelect(OPERATIONAL_PROFILE_CHOICE);
            this.operationalProfile = operationalProfile;
        }

        /** 
         * Check if AllianceProfile is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAllianceProfile() {
            return choiceSelect == ALLIANCE_PROFILE_CHOICE;
        }

        /** 
         * Get the 'AllianceProfile' element value. *** SABRE ADDED *** To hold Alliance Profile data
         * 
         * @return value
         */
        public AllianceProfileType getAllianceProfile() {
            return allianceProfile;
        }

        /** 
         * Set the 'AllianceProfile' element value. *** SABRE ADDED *** To hold Alliance Profile data
         * 
         * @param allianceProfile
         */
        public void setAllianceProfile(AllianceProfileType allianceProfile) {
            setChoiceSelect(ALLIANCE_PROFILE_CHOICE);
            this.allianceProfile = allianceProfile;
        }

        /** 
         * Check if GroupProfile is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifGroupProfile() {
            return choiceSelect == GROUP_PROFILE_CHOICE;
        }

        /** 
         * Get the 'GroupProfile' element value. ***SABRE ADDED*** To hold Corporation Profile 
         * 
         * @return value
         */
        public GroupProfileType getGroupProfile() {
            return groupProfile;
        }

        /** 
         * Set the 'GroupProfile' element value. ***SABRE ADDED*** To hold Corporation Profile 
         * 
         * @param groupProfile
         */
        public void setGroupProfile(GroupProfileType groupProfile) {
            setChoiceSelect(GROUP_PROFILE_CHOICE);
            this.groupProfile = groupProfile;
        }
    }
}
