
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Identifies a collection of preferences for airline travel.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RailPrefType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:RailStationPrefType" name="RailStationPref" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:RailSeatPrefType" name="RailSeatPref" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:RailCabinPrefType" name="RailCabinPref" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:RailMealPrefType" name="RailMealPref" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:RailUpgradePrefType" name="RailUpgradePref" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:PreferredRailVendorsType" name="PreferredRailVendors" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:PreferredAggregatorType" name="PreferredAggregator" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="TripTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoOriginCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoDestinationCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoRegionCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TicketingPreferenceCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FormOfIdentificationCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RailPrefType implements Serializable
{
    private List<RailStationPrefType> railStationPrefList = new ArrayList<RailStationPrefType>();
    private List<RailSeatPrefType> railSeatPrefList = new ArrayList<RailSeatPrefType>();
    private List<RailCabinPrefType> railCabinPrefList = new ArrayList<RailCabinPrefType>();
    private List<RailMealPrefType> railMealPrefList = new ArrayList<RailMealPrefType>();
    private List<RailUpgradePrefType> railUpgradePrefList = new ArrayList<RailUpgradePrefType>();
    private List<PreferredRailVendorsType> preferredRailVendorList = new ArrayList<PreferredRailVendorsType>();
    private List<PreferredAggregatorType> preferredAggregatorList = new ArrayList<PreferredAggregatorType>();
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String tripTypeCode;
    private String geoOriginCode;
    private String geoDestinationCode;
    private String geoRegionCode;
    private String informationText;
    private String ticketingPreferenceCode;
    private String formOfIdentificationCode;
    private String orderSequenceNo;
    private String displaySequenceNo;

    /** 
     * Get the list of 'RailStationPref' element items. ***OTA Based ***  Identifies the preferred origination rail  for travel (using IATA airport codes).
     * 
     * @return list
     */
    public List<RailStationPrefType> getRailStationPrefList() {
        return railStationPrefList;
    }

    /** 
     * Set the list of 'RailStationPref' element items. ***OTA Based ***  Identifies the preferred origination rail  for travel (using IATA airport codes).
     * 
     * @param list
     */
    public void setRailStationPrefList(List<RailStationPrefType> list) {
        railStationPrefList = list;
    }

    /** 
     * Get the list of 'RailSeatPref' element items.  ***OTA Based *** Indicates preferred seat characteristics.  Refer to OTA Code List Seat Preference (STP) for codes.Not applicable for Corporation and Agency Profile Types
     * 
     * @return list
     */
    public List<RailSeatPrefType> getRailSeatPrefList() {
        return railSeatPrefList;
    }

    /** 
     * Set the list of 'RailSeatPref' element items.  ***OTA Based *** Indicates preferred seat characteristics.  Refer to OTA Code List Seat Preference (STP) for codes.Not applicable for Corporation and Agency Profile Types
     * 
     * @param list
     */
    public void setRailSeatPrefList(List<RailSeatPrefType> list) {
        railSeatPrefList = list;
    }

    /** 
     * Get the list of 'RailCabinPref' element items.  ***OTA Based *** Indicates preferred Cabins 
     * 
     * @return list
     */
    public List<RailCabinPrefType> getRailCabinPrefList() {
        return railCabinPrefList;
    }

    /** 
     * Set the list of 'RailCabinPref' element items.  ***OTA Based *** Indicates preferred Cabins 
     * 
     * @param list
     */
    public void setRailCabinPrefList(List<RailCabinPrefType> list) {
        railCabinPrefList = list;
    }

    /** 
     * Get the list of 'RailMealPref' element items. ***OTA Based *** Indicates preferred meal type (e.g., vegetarian, Kosher, low fat) Not applicable for Corporation and Agency Profile Types
     * 
     * @return list
     */
    public List<RailMealPrefType> getRailMealPrefList() {
        return railMealPrefList;
    }

    /** 
     * Set the list of 'RailMealPref' element items. ***OTA Based *** Indicates preferred meal type (e.g., vegetarian, Kosher, low fat) Not applicable for Corporation and Agency Profile Types
     * 
     * @param list
     */
    public void setRailMealPrefList(List<RailMealPrefType> list) {
        railMealPrefList = list;
    }

    /** 
     * Get the list of 'RailUpgradePref' element items. ***OTA Based *** Indicates Upgrade Preferecnes for Airlines
     * 
     * @return list
     */
    public List<RailUpgradePrefType> getRailUpgradePrefList() {
        return railUpgradePrefList;
    }

    /** 
     * Set the list of 'RailUpgradePref' element items. ***OTA Based *** Indicates Upgrade Preferecnes for Airlines
     * 
     * @param list
     */
    public void setRailUpgradePrefList(List<RailUpgradePrefType> list) {
        railUpgradePrefList = list;
    }

    /** 
     * Get the list of 'PreferredRailVendors' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Vendors
     * 
     * @return list
     */
    public List<PreferredRailVendorsType> getPreferredRailVendorList() {
        return preferredRailVendorList;
    }

    /** 
     * Set the list of 'PreferredRailVendors' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Vendors
     * 
     * @param list
     */
    public void setPreferredRailVendorList(List<PreferredRailVendorsType> list) {
        preferredRailVendorList = list;
    }

    /** 
     * Get the list of 'PreferredAggregator' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Aggregators
     * 
     * @return list
     */
    public List<PreferredAggregatorType> getPreferredAggregatorList() {
        return preferredAggregatorList;
    }

    /** 
     * Set the list of 'PreferredAggregator' element items. ***SABRE ADDED*** Stores List of Preferred and excluded Aggregators
     * 
     * @param list
     */
    public void setPreferredAggregatorList(List<PreferredAggregatorType> list) {
        preferredAggregatorList = list;
    }

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @return value
     */
    public String getTripTypeCode() {
        return tripTypeCode;
    }

    /** 
     * Set the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @param tripTypeCode
     */
    public void setTripTypeCode(String tripTypeCode) {
        this.tripTypeCode = tripTypeCode;
    }

    /** 
     * Get the 'GeoOriginCode' attribute value. Origin Code	
     * 
     * @return value
     */
    public String getGeoOriginCode() {
        return geoOriginCode;
    }

    /** 
     * Set the 'GeoOriginCode' attribute value. Origin Code	
     * 
     * @param geoOriginCode
     */
    public void setGeoOriginCode(String geoOriginCode) {
        this.geoOriginCode = geoOriginCode;
    }

    /** 
     * Get the 'GeoDestinationCode' attribute value. Des type Code	
     * 
     * @return value
     */
    public String getGeoDestinationCode() {
        return geoDestinationCode;
    }

    /** 
     * Set the 'GeoDestinationCode' attribute value. Des type Code	
     * 
     * @param geoDestinationCode
     */
    public void setGeoDestinationCode(String geoDestinationCode) {
        this.geoDestinationCode = geoDestinationCode;
    }

    /** 
     * Get the 'GeoRegionCode' attribute value. Trip type Code	
     * 
     * @return value
     */
    public String getGeoRegionCode() {
        return geoRegionCode;
    }

    /** 
     * Set the 'GeoRegionCode' attribute value. Trip type Code	
     * 
     * @param geoRegionCode
     */
    public void setGeoRegionCode(String geoRegionCode) {
        this.geoRegionCode = geoRegionCode;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'TicketingPreferenceCode' attribute value. Preferred method of ticketing
     * 
     * @return value
     */
    public String getTicketingPreferenceCode() {
        return ticketingPreferenceCode;
    }

    /** 
     * Set the 'TicketingPreferenceCode' attribute value. Preferred method of ticketing
     * 
     * @param ticketingPreferenceCode
     */
    public void setTicketingPreferenceCode(String ticketingPreferenceCode) {
        this.ticketingPreferenceCode = ticketingPreferenceCode;
    }

    /** 
     * Get the 'FormOfIdentificationCode' attribute value. Form of identification preference
     * 
     * @return value
     */
    public String getFormOfIdentificationCode() {
        return formOfIdentificationCode;
    }

    /** 
     * Set the 'FormOfIdentificationCode' attribute value. Form of identification preference
     * 
     * @param formOfIdentificationCode
     */
    public void setFormOfIdentificationCode(String formOfIdentificationCode) {
        this.formOfIdentificationCode = formOfIdentificationCode;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value.
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value.
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }
}
