
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RailSeatInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:SeatAmenityType" name="SeatAmenity" minOccurs="0" maxOccurs="10"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DirectionCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SeatNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SeatPreferenceCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VendorCode"/>
 *   &lt;xs:attribute type="ns:IndicatorType" use="optional" name="SmokingInd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ZoneCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RailSeatInfoType implements Serializable
{
    private List<SeatAmenityType> seatAmenityList = new ArrayList<SeatAmenityType>();
    private String directionCode;
    private String seatNumber;
    private String seatPreferenceCode;
    private String vendorCode;
    private IndicatorType smokingInd;
    private String zoneCode;

    /** 
     * Get the list of 'SeatAmenity' element items. Seat amenity preferences.
     * 
     * @return list
     */
    public List<SeatAmenityType> getSeatAmenityList() {
        return seatAmenityList;
    }

    /** 
     * Set the list of 'SeatAmenity' element items. Seat amenity preferences.
     * 
     * @param list
     */
    public void setSeatAmenityList(List<SeatAmenityType> list) {
        seatAmenityList = list;
    }

    /** 
     * Get the 'DirectionCode' attribute value. Seat direction preference
     * 
     * @return value
     */
    public String getDirectionCode() {
        return directionCode;
    }

    /** 
     * Set the 'DirectionCode' attribute value. Seat direction preference
     * 
     * @param directionCode
     */
    public void setDirectionCode(String directionCode) {
        this.directionCode = directionCode;
    }

    /** 
     * Get the 'SeatNumber' attribute value. Used to provide the seat number.
     * 
     * @return value
     */
    public String getSeatNumber() {
        return seatNumber;
    }

    /** 
     * Set the 'SeatNumber' attribute value. Used to provide the seat number.
     * 
     * @param seatNumber
     */
    public void setSeatNumber(String seatNumber) {
        this.seatNumber = seatNumber;
    }

    /** 
     * Get the 'SeatPreferenceCode' attribute value. Refer to  Code List Seat Preference (STP).

     * 
     * @return value
     */
    public String getSeatPreferenceCode() {
        return seatPreferenceCode;
    }

    /** 
     * Set the 'SeatPreferenceCode' attribute value. Refer to  Code List Seat Preference (STP).

     * 
     * @param seatPreferenceCode
     */
    public void setSeatPreferenceCode(String seatPreferenceCode) {
        this.seatPreferenceCode = seatPreferenceCode;
    }

    /** 
     * Get the 'VendorCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'SmokingInd' attribute value. Smoking preference
     * 
     * @return value
     */
    public IndicatorType getSmokingInd() {
        return smokingInd;
    }

    /** 
     * Set the 'SmokingInd' attribute value. Smoking preference
     * 
     * @param smokingInd
     */
    public void setSmokingInd(IndicatorType smokingInd) {
        this.smokingInd = smokingInd;
    }

    /** 
     * Get the 'ZoneCode' attribute value. Seat zone preference
     * 
     * @return value
     */
    public String getZoneCode() {
        return zoneCode;
    }

    /** 
     * Set the 'ZoneCode' attribute value. Seat zone preference
     * 
     * @param zoneCode
     */
    public void setZoneCode(String zoneCode) {
        this.zoneCode = zoneCode;
    }
}
