
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RailSeatPrefType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:RailSeatInfoType" name="SeatInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PreferLevelCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RailSeatPrefType implements Serializable
{
    private RailSeatInfoType seatInfo;
    private TransactionalDataType transactionalData;
    private String preferLevelCode;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String informationText;

    /** 
     * Get the 'SeatInfo' element value.
     * 
     * @return value
     */
    public RailSeatInfoType getSeatInfo() {
        return seatInfo;
    }

    /** 
     * Set the 'SeatInfo' element value.
     * 
     * @param seatInfo
     */
    public void setSeatInfo(RailSeatInfoType seatInfo) {
        this.seatInfo = seatInfo;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'PreferLevelCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @return value
     */
    public String getPreferLevelCode() {
        return preferLevelCode;
    }

    /** 
     * Set the 'PreferLevelCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @param preferLevelCode
     */
    public void setPreferLevelCode(String preferLevelCode) {
        this.preferLevelCode = preferLevelCode;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Code used to identify a location.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Code used to identify a location.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'InformationText' attribute value. Refer to OTA Code List Seat Preference (STP).

     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Refer to OTA Code List Seat Preference (STP).

     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }
}
