
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RailStationInfoType">
 *   &lt;xs:attribute type="xs:string" use="required" name="RailStationCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LocationTypeCode"/>
 *   &lt;xs:attribute type="xs:string" default="IATA" name="ContextCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RailStationInfoType implements Serializable
{
    private String railStationCode;
    private String locationTypeCode;
    private String contextCode;

    /** 
     * Get the 'RailStationCode' attribute value. Code of the Rail Station.
     * 
     * @return value
     */
    public String getRailStationCode() {
        return railStationCode;
    }

    /** 
     * Set the 'RailStationCode' attribute value. Code of the Rail Station.
     * 
     * @param railStationCode
     */
    public void setRailStationCode(String railStationCode) {
        this.railStationCode = railStationCode;
    }

    /** 
     * Get the 'LocationTypeCode' attribute value. Code used to identify a location. 
     * 
     * @return value
     */
    public String getLocationTypeCode() {
        return locationTypeCode;
    }

    /** 
     * Set the 'LocationTypeCode' attribute value. Code used to identify a location. 
     * 
     * @param locationTypeCode
     */
    public void setLocationTypeCode(String locationTypeCode) {
        this.locationTypeCode = locationTypeCode;
    }

    /** 
     * Get the 'ContextCode' attribute value. Coding standard for LocationTypeCode *** DEPRECATED *** This attribute will become REQUIRED in the next major release.
     * 
     * @return value
     */
    public String getContextCode() {
        return contextCode;
    }

    /** 
     * Set the 'ContextCode' attribute value. Coding standard for LocationTypeCode *** DEPRECATED *** This attribute will become REQUIRED in the next major release.
     * 
     * @param contextCode
     */
    public void setContextCode(String contextCode) {
        this.contextCode = contextCode;
    }
}
