
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RestoreType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:RestoreProfileType" name="Profile"/>
 *     &lt;xs:element type="ns:RestoreTemplateType" name="Template"/>
 *     &lt;xs:element type="ns:RestoreFilterType" name="Filter"/>
 *     &lt;xs:element type="ns:RestoreFormatType" name="Format"/>
 *     &lt;xs:element type="ns:RestoreDomainType" name="Domain"/>
 *     &lt;xs:element type="ns:RestoreDomainProfilesType" name="DomainProfiles"/>
 *     &lt;xs:element type="ns:RestoreDomainTemplatesType" name="DomainTemplates"/>
 *     &lt;xs:element type="ns:RestoreDomainFiltersType" name="DomainFilters"/>
 *     &lt;xs:element type="ns:RestoreDomainFormatsType" name="DomainFormats"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RestoreType implements Serializable
{
    private int choiceSelect = -1;
    private static final int PROFILE_CHOICE = 0;
    private static final int TEMPLATE_CHOICE = 1;
    private static final int FILTER_CHOICE = 2;
    private static final int FORMAT_CHOICE = 3;
    private static final int DOMAIN_CHOICE = 4;
    private static final int DOMAIN_PROFILES_CHOICE = 5;
    private static final int DOMAIN_TEMPLATES_CHOICE = 6;
    private static final int DOMAIN_FILTERS_CHOICE = 7;
    private static final int DOMAIN_FORMATS_CHOICE = 8;
    private RestoreProfileType profile;
    private RestoreTemplateType template;
    private RestoreFilterType filter;
    private RestoreFormatType format;
    private RestoreDomainType domain;
    private RestoreDomainProfilesType domainProfiles;
    private RestoreDomainTemplatesType domainTemplates;
    private RestoreDomainFiltersType domainFilters;
    private RestoreDomainFormatsType domainFormats;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Profile is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProfile() {
        return choiceSelect == PROFILE_CHOICE;
    }

    /** 
     * Get the 'Profile' element value. *** SABRE ADDED *** Delete Profiles
     * 
     * @return value
     */
    public RestoreProfileType getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value. *** SABRE ADDED *** Delete Profiles
     * 
     * @param profile
     */
    public void setProfile(RestoreProfileType profile) {
        setChoiceSelect(PROFILE_CHOICE);
        this.profile = profile;
    }

    /** 
     * Check if Template is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTemplate() {
        return choiceSelect == TEMPLATE_CHOICE;
    }

    /** 
     * Get the 'Template' element value. *** DEPRECATED *** Template is subject to immediate delete
     * 
     * @return value
     */
    public RestoreTemplateType getTemplate() {
        return template;
    }

    /** 
     * Set the 'Template' element value. *** DEPRECATED *** Template is subject to immediate delete
     * 
     * @param template
     */
    public void setTemplate(RestoreTemplateType template) {
        setChoiceSelect(TEMPLATE_CHOICE);
        this.template = template;
    }

    /** 
     * Check if Filter is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFilter() {
        return choiceSelect == FILTER_CHOICE;
    }

    /** 
     * Get the 'Filter' element value. *** DEPRECATED *** Filter is subject to immediate delete
     * 
     * @return value
     */
    public RestoreFilterType getFilter() {
        return filter;
    }

    /** 
     * Set the 'Filter' element value. *** DEPRECATED *** Filter is subject to immediate delete
     * 
     * @param filter
     */
    public void setFilter(RestoreFilterType filter) {
        setChoiceSelect(FILTER_CHOICE);
        this.filter = filter;
    }

    /** 
     * Check if Format is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFormat() {
        return choiceSelect == FORMAT_CHOICE;
    }

    /** 
     * Get the 'Format' element value. *** DEPRECATED *** Format is subject to immediate delete
     * 
     * @return value
     */
    public RestoreFormatType getFormat() {
        return format;
    }

    /** 
     * Set the 'Format' element value. *** DEPRECATED *** Format is subject to immediate delete
     * 
     * @param format
     */
    public void setFormat(RestoreFormatType format) {
        setChoiceSelect(FORMAT_CHOICE);
        this.format = format;
    }

    /** 
     * Check if Domain is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDomain() {
        return choiceSelect == DOMAIN_CHOICE;
    }

    /** 
     * Get the 'Domain' element value. *** SABRE ADDED *** Information about structure to drop Domain 
     * 
     * @return value
     */
    public RestoreDomainType getDomain() {
        return domain;
    }

    /** 
     * Set the 'Domain' element value. *** SABRE ADDED *** Information about structure to drop Domain 
     * 
     * @param domain
     */
    public void setDomain(RestoreDomainType domain) {
        setChoiceSelect(DOMAIN_CHOICE);
        this.domain = domain;
    }

    /** 
     * Check if DomainProfiles is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDomainProfiles() {
        return choiceSelect == DOMAIN_PROFILES_CHOICE;
    }

    /** 
     * Get the 'DomainProfiles' element value. *** SABRE ADDED *** Information about Restoreall profiles in a domain
     * 
     * @return value
     */
    public RestoreDomainProfilesType getDomainProfiles() {
        return domainProfiles;
    }

    /** 
     * Set the 'DomainProfiles' element value. *** SABRE ADDED *** Information about Restoreall profiles in a domain
     * 
     * @param domainProfiles
     */
    public void setDomainProfiles(RestoreDomainProfilesType domainProfiles) {
        setChoiceSelect(DOMAIN_PROFILES_CHOICE);
        this.domainProfiles = domainProfiles;
    }

    /** 
     * Check if DomainTemplates is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDomainTemplates() {
        return choiceSelect == DOMAIN_TEMPLATES_CHOICE;
    }

    /** 
     * Get the 'DomainTemplates' element value. *** SABRE ADDED *** Information about Restoreall templates in a domain
     * 
     * @return value
     */
    public RestoreDomainTemplatesType getDomainTemplates() {
        return domainTemplates;
    }

    /** 
     * Set the 'DomainTemplates' element value. *** SABRE ADDED *** Information about Restoreall templates in a domain
     * 
     * @param domainTemplates
     */
    public void setDomainTemplates(RestoreDomainTemplatesType domainTemplates) {
        setChoiceSelect(DOMAIN_TEMPLATES_CHOICE);
        this.domainTemplates = domainTemplates;
    }

    /** 
     * Check if DomainFilters is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDomainFilters() {
        return choiceSelect == DOMAIN_FILTERS_CHOICE;
    }

    /** 
     * Get the 'DomainFilters' element value. *** SABRE ADDED *** Information about Restoreall filters in a domain
     * 
     * @return value
     */
    public RestoreDomainFiltersType getDomainFilters() {
        return domainFilters;
    }

    /** 
     * Set the 'DomainFilters' element value. *** SABRE ADDED *** Information about Restoreall filters in a domain
     * 
     * @param domainFilters
     */
    public void setDomainFilters(RestoreDomainFiltersType domainFilters) {
        setChoiceSelect(DOMAIN_FILTERS_CHOICE);
        this.domainFilters = domainFilters;
    }

    /** 
     * Check if DomainFormats is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDomainFormats() {
        return choiceSelect == DOMAIN_FORMATS_CHOICE;
    }

    /** 
     * Get the 'DomainFormats' element value. *** SABRE ADDED *** Information about Restoreall formats in a domain
     * 
     * @return value
     */
    public RestoreDomainFormatsType getDomainFormats() {
        return domainFormats;
    }

    /** 
     * Set the 'DomainFormats' element value. *** SABRE ADDED *** Information about Restoreall formats in a domain
     * 
     * @param domainFormats
     */
    public void setDomainFormats(RestoreDomainFormatsType domainFormats) {
        setChoiceSelect(DOMAIN_FORMATS_CHOICE);
        this.domainFormats = domainFormats;
    }
}
